/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import world.landfall.verbatim.ChatChannelManager;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.chat.ChatFocus;
import world.landfall.verbatim.chat.FocusTarget;
import world.landfall.verbatim.discord.DiscordBot;
import world.landfall.verbatim.specialchannels.FormattedMessageDetails;
import world.landfall.verbatim.specialchannels.LocalChannelFormatter;
import world.landfall.verbatim.util.NicknameService;

public class ChatEvents {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!ChatChannelManager.isInitialized()) {
                Verbatim.LOGGER.warn("[Verbatim ChatEvent] ChatChannelManager not yet initialized during login for {}. Skipping channel setup.", (Object)player2.getName().getString());
                return;
            }
            ChatChannelManager.playerLoggedIn(player2);
            if (DiscordBot.isEnabled()) {
                DiscordBot.sendPlayerConnectionStatusToDiscord(player2, true);
            }
            ChatChannelManager.getFocus(player2).ifPresent(focus -> {
                if (focus instanceof ChatFocus && ((ChatFocus)focus).getType() == ChatFocus.FocusType.CHANNEL) {
                    ChatChannelManager.ChannelConfig config = ChatChannelManager.getChannelConfigByName(((ChatFocus)focus).getChannelName()).orElse(null);
                    if (config != null) {
                        player2.sendSystemMessage((Component)Component.literal((String)"\ud83d\udde8 Focused channel: ").append(ChatFormattingUtils.parseColors(config.displayPrefix)).append((Component)Component.literal((String)(" " + config.name)).withStyle(ChatFormatting.YELLOW)));
                    }
                } else if (focus instanceof ChatFocus && ((ChatFocus)focus).getType() == ChatFocus.FocusType.DM) {
                    player2.sendSystemMessage((Component)Component.literal((String)"\ud83d\udcac Focused DM: ").append((Component)Component.literal((String)focus.getDisplayName()).withStyle(ChatFormatting.YELLOW)));
                }
            });
            Set<String> joinedChannels = ChatChannelManager.getJoinedChannels(player2);
            if (!joinedChannels.isEmpty()) {
                player2.sendSystemMessage((Component)Component.literal((String)"\ud83d\udcde Joined channels: ").withStyle(ChatFormatting.GRAY));
                for (String joinedChannelName : joinedChannels) {
                    ChatChannelManager.getChannelConfigByName(joinedChannelName).ifPresent(jc -> player2.sendSystemMessage((Component)Component.literal((String)"  - ").append(ChatFormattingUtils.parseColors(jc.displayPrefix)).append((Component)Component.literal((String)(" " + jc.name)).withStyle(ChatFormatting.DARK_AQUA))));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (DiscordBot.isEnabled()) {
                DiscordBot.sendPlayerConnectionStatusToDiscord(player2, false);
            }
            ChatChannelManager.playerLoggedOut(player2);
            NicknameService.onPlayerLogout(player2.getUUID());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        Optional<Object> targetFocusOpt;
        String messageContent;
        ServerPlayer sender;
        block35: {
            sender = event.getPlayer();
            String rawMessageText = event.getMessage().getString();
            Verbatim.LOGGER.debug("[Verbatim ChatEvent] Raw message from {}: {}", (Object)sender.getName().getString(), (Object)rawMessageText);
            event.setCanceled(true);
            if (!ChatChannelManager.isInitialized()) {
                Verbatim.LOGGER.warn("[Verbatim ChatEvent] ChatChannelManager not yet initialized. Deferring message from {}.", (Object)sender.getName().getString());
                sender.sendSystemMessage((Component)Component.literal((String)"Chat system is still initializing. Please try again in a moment.").withStyle(ChatFormatting.YELLOW));
                return;
            }
            messageContent = rawMessageText;
            targetFocusOpt = Optional.empty();
            int colonIndex = rawMessageText.indexOf(58);
            int semicolonIndex = rawMessageText.indexOf(59);
            int separatorIndex = -1;
            if (colonIndex != -1 && semicolonIndex != -1) {
                separatorIndex = Math.min(colonIndex, semicolonIndex);
            } else if (colonIndex != -1) {
                separatorIndex = colonIndex;
            } else if (semicolonIndex != -1) {
                separatorIndex = semicolonIndex;
            }
            if (separatorIndex != -1 && separatorIndex > 0) {
                String potentialPrefix = rawMessageText.substring(0, separatorIndex);
                if ("d".equals(potentialPrefix)) {
                    ChatChannelManager.handleDPrefix(sender);
                    messageContent = rawMessageText.substring(separatorIndex + 1).trim();
                    if (messageContent.isEmpty()) {
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] d: prefix used with no message. Focus changed only.");
                        return;
                    }
                    Optional<FocusTarget> currentFocus = ChatChannelManager.getFocus(sender);
                    if (currentFocus.isPresent() && currentFocus.get() instanceof ChatFocus && ((ChatFocus)currentFocus.get()).getType() == ChatFocus.FocusType.DM) {
                        targetFocusOpt = currentFocus;
                        break block35;
                    } else {
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] d: prefix failed to establish DM focus. Message not sent.");
                        return;
                    }
                }
                if ("g".equals(potentialPrefix)) {
                    ChatChannelManager.ChannelConfig defaultChannel = ChatChannelManager.getDefaultChannelConfig();
                    if (defaultChannel == null) {
                        sender.sendSystemMessage((Component)Component.literal((String)"No default channel configured for 'g:' prefix.").withStyle(ChatFormatting.RED));
                        return;
                    }
                    ChatChannelManager.focusChannel(sender, defaultChannel.name);
                    targetFocusOpt = Optional.of(ChatFocus.createChannelFocus(defaultChannel.name));
                    messageContent = rawMessageText.substring(separatorIndex + 1).trim();
                    if (messageContent.isEmpty()) {
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] g: prefix used with no message. Focus changed only.");
                        return;
                    }
                } else {
                    Optional<ChatChannelManager.ChannelConfig> targetChannelByShortcut = ChatChannelManager.getChannelConfigByShortcut(potentialPrefix);
                    if (targetChannelByShortcut.isPresent()) {
                        ChatChannelManager.ChannelConfig prospectiveChannel = targetChannelByShortcut.get();
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] Shortcut '{}' targets channel: {}. Checking permission...", (Object)potentialPrefix, (Object)prospectiveChannel.name);
                        ChatChannelManager.focusChannel(sender, prospectiveChannel.name);
                        if (!ChatChannelManager.isJoined(sender, prospectiveChannel.name)) return;
                        targetFocusOpt = Optional.of(ChatFocus.createChannelFocus(prospectiveChannel.name));
                        messageContent = rawMessageText.substring(separatorIndex + 1).trim();
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] Shortcut permission GRANTED for '{}'. Player focused. Message content: \"{}\"", (Object)prospectiveChannel.name, (Object)messageContent);
                        if (messageContent.isEmpty()) {
                            Verbatim.LOGGER.debug("[Verbatim ChatEvent] Message content empty after shortcut processing for '{}'. No message to send.", (Object)prospectiveChannel.name);
                            return;
                        }
                    } else {
                        Verbatim.LOGGER.debug("[Verbatim ChatEvent] No channel found for shortcut: {}", (Object)potentialPrefix);
                    }
                }
            }
        }
        if (targetFocusOpt.isEmpty() && (targetFocusOpt = ChatChannelManager.getFocus(sender)).isEmpty()) {
            Verbatim.LOGGER.error("[Verbatim ChatEvent] Player {} has no focus. Attempting to set to default.", (Object)sender.getName().getString());
            ChatChannelManager.ChannelConfig defaultChannel = ChatChannelManager.getDefaultChannelConfig();
            if (defaultChannel == null) {
                Verbatim.LOGGER.error("[Verbatim ChatEvent] CRITICAL: No default channel to focus for {}. Cannot send message.", (Object)sender.getName().getString());
                sender.sendSystemMessage((Component)Component.literal((String)"Error: No active or default channel. Message not sent.").withStyle(ChatFormatting.RED));
                return;
            }
            ChatChannelManager.focusChannel(sender, defaultChannel.name);
            targetFocusOpt = Optional.of(ChatFocus.createChannelFocus(defaultChannel.name));
            sender.sendSystemMessage((Component)Component.literal((String)"You were not focused on anything. Message sent to default: ").append(ChatFormattingUtils.parseColors(defaultChannel.displayPrefix)).append((Component)Component.literal((String)(" " + defaultChannel.name)).withStyle(ChatFormatting.YELLOW)));
        }
        FocusTarget finalTarget = (FocusTarget)targetFocusOpt.get();
        try {
            int effectiveRange;
            MutableComponent finalMessage;
            Optional<FormattedMessageDetails> specialFormatResult;
            if (finalTarget instanceof ChatFocus && ((ChatFocus)finalTarget).getType() == ChatFocus.FocusType.DM) {
                ChatFocus dmFocus = (ChatFocus)finalTarget;
                ServerPlayer targetPlayer = ChatChannelManager.getPlayerByUUID(dmFocus.getTargetPlayerId());
                if (targetPlayer == null) {
                    sender.sendSystemMessage((Component)Component.literal((String)"Cannot send DM: Target player is not online.").withStyle(ChatFormatting.RED));
                    return;
                }
                ChatChannelManager.setLastIncomingDmSender(targetPlayer, sender.getUUID());
                MutableComponent senderMessage = Component.literal((String)"[You -> ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)targetPlayer.getName().getString()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"]: ").withStyle(ChatFormatting.LIGHT_PURPLE)).append(ChatFormattingUtils.parsePlayerInputWithPermissions("&f", messageContent, sender));
                MutableComponent recipientMessage = Component.literal((String)"[").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)sender.getName().getString()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" -> You]: ").withStyle(ChatFormatting.LIGHT_PURPLE)).append(ChatFormattingUtils.parsePlayerInputWithPermissions("&f", messageContent, sender));
                sender.sendSystemMessage((Component)senderMessage);
                targetPlayer.sendSystemMessage((Component)recipientMessage);
                return;
            }
            if (!(finalTarget instanceof ChatFocus)) return;
            if (((ChatFocus)finalTarget).getType() != ChatFocus.FocusType.CHANNEL) return;
            ChatFocus channelFocus = (ChatFocus)finalTarget;
            Optional<ChatChannelManager.ChannelConfig> channelConfigOpt = ChatChannelManager.getChannelConfigByName(channelFocus.getChannelName());
            if (channelConfigOpt.isEmpty()) {
                sender.sendSystemMessage((Component)Component.literal((String)"Error: Focused channel no longer exists.").withStyle(ChatFormatting.RED));
                return;
            }
            ChatChannelManager.ChannelConfig finalTargetChannel = channelConfigOpt.get();
            if (!finalTargetChannel.alwaysOn && finalTargetChannel.permission.isPresent() && !Verbatim.permissionService.hasPermission(sender, finalTargetChannel.permission.get(), 2)) {
                Verbatim.LOGGER.info("[Verbatim ChatEvent] Player {} lost permission to send to target channel '{}'. Auto-leaving & focusing default.", (Object)sender.getName().getString(), (Object)finalTargetChannel.name);
                ChatChannelManager.autoLeaveChannel(sender, finalTargetChannel.name);
                sender.sendSystemMessage((Component)Component.literal((String)"You no longer have permission to send messages in '").append(ChatFormattingUtils.parseColors(finalTargetChannel.displayPrefix + " " + finalTargetChannel.name)).append((Component)Component.literal((String)"'. Message not sent.")).withStyle(ChatFormatting.RED));
                return;
            }
            if (DiscordBot.isEnabled() && "global".equals(finalTargetChannel.name)) {
                DiscordBot.sendPlayerChatMessageToDiscord(sender, messageContent);
            }
            if ((specialFormatResult = LocalChannelFormatter.formatLocalMessage(sender, finalTargetChannel, messageContent)).isPresent()) {
                FormattedMessageDetails details2 = specialFormatResult.get();
                finalMessage = details2.formattedMessage;
                effectiveRange = details2.effectiveRange;
            } else {
                effectiveRange = finalTargetChannel.range;
                finalMessage = Component.empty();
                finalMessage.append(ChatFormattingUtils.parseColors(finalTargetChannel.displayPrefix));
                finalMessage.append((Component)Component.literal((String)" "));
                Component playerNameComponent = ChatFormattingUtils.createPlayerNameComponent(sender, finalTargetChannel.nameColor, false, finalTargetChannel.nameStyle);
                finalMessage.append(playerNameComponent);
                finalMessage.append(ChatFormattingUtils.parseColors(finalTargetChannel.separatorColor + finalTargetChannel.separator));
                finalMessage.append(ChatFormattingUtils.parsePlayerInputWithPermissions(finalTargetChannel.messageColor, messageContent, sender));
            }
            MinecraftServer server = sender.getServer();
            if (server == null) {
                Verbatim.LOGGER.error("[Verbatim ChatEvent] Server instance is null while processing message from {}", (Object)sender.getName().getString());
                return;
            }
            Iterator iterator = server.getPlayerList().getPlayers().iterator();
            while (iterator.hasNext()) {
                ServerPlayer recipient = (ServerPlayer)iterator.next();
                if (!ChatChannelManager.isJoined(recipient, finalTargetChannel.name)) continue;
                if (finalTargetChannel.alwaysOn || !finalTargetChannel.permission.isPresent() || Verbatim.permissionService.hasPermission(recipient, finalTargetChannel.permission.get(), 2)) {
                    if (effectiveRange >= 0) {
                        double distSqr = recipient.distanceToSqr((Entity)sender);
                        if (recipient.equals((Object)sender)) {
                            recipient.sendSystemMessage((Component)finalMessage);
                            continue;
                        }
                        MutableComponent messageToSend = specialFormatResult.map(details -> details.getMessageForDistance(distSqr)).orElseGet(() -> distSqr <= (double)(effectiveRange * effectiveRange) ? finalMessage : null);
                        if (messageToSend == null) continue;
                        recipient.sendSystemMessage((Component)messageToSend);
                        continue;
                    }
                    recipient.sendSystemMessage((Component)finalMessage);
                    continue;
                }
                Verbatim.LOGGER.info("[Verbatim ChatEvent] Recipient {} is joined to '{}' but lost permission. Auto-leaving.", (Object)recipient.getName().getString(), (Object)finalTargetChannel.name);
                ChatChannelManager.autoLeaveChannel(recipient, finalTargetChannel.name);
            }
            return;
        }
        catch (NoClassDefFoundError e) {
            Verbatim.LOGGER.error("[Verbatim ChatEvent] Class loading error during message processing. Chat system may still be initializing.", (Throwable)e);
            sender.sendSystemMessage((Component)Component.literal((String)"Chat system is still initializing. Please try again in a moment.").withStyle(ChatFormatting.YELLOW));
            return;
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[Verbatim ChatEvent] Unexpected error during message processing.", (Throwable)e);
            sender.sendSystemMessage((Component)Component.literal((String)"An error occurred while processing your message.").withStyle(ChatFormatting.RED));
        }
    }

    public static void onConfigReload() {
        ChatChannelManager.loadConfiguredChannels();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                Set<String> currentJoined = ChatChannelManager.getJoinedChannels(player);
                for (String joinedChannelName : new HashSet<String>(currentJoined)) {
                    ChatChannelManager.getChannelConfigByName(joinedChannelName).ifPresent(config -> {
                        if (!config.alwaysOn && config.permission.isPresent() && !Verbatim.permissionService.hasPermission(player, config.permission.get(), 2)) {
                            Verbatim.LOGGER.info("[Verbatim ConfigReload] Player {} lost permission for joined channel '{}' after config reload. Auto-leaving.", (Object)player.getName().getString(), (Object)config.name);
                            ChatChannelManager.autoLeaveChannel(player, config.name);
                        }
                    });
                }
                for (ChatChannelManager.ChannelConfig config2 : ChatChannelManager.getAllChannelConfigs()) {
                    if (!config2.alwaysOn) continue;
                    ChatChannelManager.joinChannel(player, config2.name);
                }
                ChatChannelManager.getFocusedChannelConfig(player).ifPresentOrElse(focusedConfig -> {
                    if (!ChatChannelManager.isJoined(player, focusedConfig.name)) {
                        Verbatim.LOGGER.info("[Verbatim ConfigReload] Player {}'s focused channel '{}' is no longer joined. Resetting focus.", (Object)player.getName().getString(), (Object)focusedConfig.name);
                        ChatChannelManager.ChannelConfig defaultChannel = ChatChannelManager.getDefaultChannelConfig();
                        if (defaultChannel != null) {
                            ChatChannelManager.focusChannel(player, defaultChannel.name);
                        }
                    }
                }, () -> {
                    Verbatim.LOGGER.info("[Verbatim ConfigReload] Player {} has no focused channel. Resetting focus.", (Object)player.getName().getString());
                    ChatChannelManager.ChannelConfig defaultChannel = ChatChannelManager.getDefaultChannelConfig();
                    if (defaultChannel != null) {
                        ChatChannelManager.focusChannel(player, defaultChannel.name);
                    }
                });
            }
            Verbatim.LOGGER.info("[Verbatim ConfigReload] Player channel states re-evaluated.");
        }
    }
}

