/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.NameStyle;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.util.NicknameService;

public class ChatFormattingUtils {
    public static final String PERM_CHAT_COLOR = "verbatim.chatcolor";
    public static final String PERM_CHAT_FORMAT = "verbatim.chatformat";

    public static Component parseColors(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        MutableComponent mainComponent = Component.literal((String)"");
        String[] parts = text.split("(?i)(?=&[0-9a-fk-or])");
        Style currentStyle = Style.EMPTY;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (part.startsWith("&") && part.length() >= 2) {
                char code = part.charAt(1);
                ChatFormatting formatting = ChatFormatting.getByCode((char)code);
                String textContent = part.substring(2);
                if (formatting != null) {
                    currentStyle = formatting.isColor() ? Style.EMPTY.withColor(formatting) : (formatting == ChatFormatting.RESET ? Style.EMPTY : ChatFormattingUtils.applyStyle(currentStyle, formatting));
                }
                if (textContent.isEmpty()) continue;
                mainComponent.append((Component)Component.literal((String)textContent).setStyle(currentStyle));
                continue;
            }
            mainComponent.append((Component)Component.literal((String)part).setStyle(currentStyle));
        }
        return mainComponent;
    }

    private static Style applyStyle(Style baseStyle, ChatFormatting format) {
        if (format == ChatFormatting.BOLD) {
            return baseStyle.withBold(Boolean.valueOf(true));
        }
        if (format == ChatFormatting.ITALIC) {
            return baseStyle.withItalic(Boolean.valueOf(true));
        }
        if (format == ChatFormatting.UNDERLINE) {
            return baseStyle.withUnderlined(Boolean.valueOf(true));
        }
        if (format == ChatFormatting.STRIKETHROUGH) {
            return baseStyle.withStrikethrough(Boolean.valueOf(true));
        }
        if (format == ChatFormatting.OBFUSCATED) {
            return baseStyle.withObfuscated(Boolean.valueOf(true));
        }
        return baseStyle;
    }

    public static Component createPlayerNameComponent(ServerPlayer player, String colorPrefix, boolean isDM, NameStyle nameStyle) {
        String nameToShow;
        String username = player.getName().getString();
        String displayName = player.getDisplayName().getString();
        String strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(displayName);
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + username + " ");
        HoverEvent hoverEvent = null;
        if (isDM) {
            nameToShow = username;
        } else if (nameStyle != null) {
            nameToShow = NicknameService.getNameForStyle(player, nameStyle);
            if (nameStyle == NameStyle.NICKNAME) {
                String nickname = NicknameService.getNickname(player);
                if (nickname != null && !nickname.trim().isEmpty()) {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Username: " + username)).withStyle(ChatFormatting.GRAY));
                }
            } else if (nameStyle == NameStyle.DISPLAY_NAME && !username.equals(strippedDisplayName)) {
                hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Username: " + username)).withStyle(ChatFormatting.GRAY));
            }
        } else if (!username.equals(strippedDisplayName)) {
            nameToShow = strippedDisplayName;
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Username: " + username)).withStyle(ChatFormatting.GRAY));
        } else {
            nameToShow = username;
        }
        String luckPermsPrefix = "";
        String prefixTooltipText = Verbatim.prefixService != null && Verbatim.prefixService.isLuckPermsAvailable() ? (!(luckPermsPrefix = Verbatim.prefixService.getPlayerPrefix(player)).isEmpty() ? Verbatim.prefixService.getPrefixTooltip(player) : null) : null;
        MutableComponent fullNameComponent = Component.empty();
        if (!luckPermsPrefix.isEmpty()) {
            MutableComponent prefixComponent = (MutableComponent)ChatFormattingUtils.parseColors(luckPermsPrefix);
            if (prefixTooltipText != null && !prefixTooltipText.isEmpty()) {
                Component tooltipComponent = ChatFormattingUtils.parseColors(prefixTooltipText);
                prefixComponent = prefixComponent.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tooltipComponent)));
            }
            fullNameComponent.append((Component)prefixComponent);
            if (!luckPermsPrefix.endsWith(" ")) {
                fullNameComponent.append((Component)Component.literal((String)" "));
            }
        }
        MutableComponent nameComponent = (MutableComponent)ChatFormattingUtils.parseColors(colorPrefix + nameToShow);
        HoverEvent finalHoverEvent = hoverEvent;
        nameComponent = nameComponent.withStyle(style -> {
            Style updatedStyle = style.withClickEvent(clickEvent);
            if (finalHoverEvent != null) {
                updatedStyle = updatedStyle.withHoverEvent(finalHoverEvent);
            }
            return updatedStyle;
        });
        fullNameComponent.append((Component)nameComponent);
        return fullNameComponent;
    }

    public static Component createPlayerNameComponent(ServerPlayer player, String colorPrefix, boolean isDM) {
        return ChatFormattingUtils.createPlayerNameComponent(player, colorPrefix, isDM, null);
    }

    public static String createDiscordPlayerName(ServerPlayer player) {
        String displayName;
        String cleanDisplayName;
        String username = player.getName().getString();
        if (!username.equals(cleanDisplayName = (displayName = player.getDisplayName().getString()).replaceAll("\u00a7[0-9a-fk-or]", ""))) {
            return username + " (" + cleanDisplayName + ")";
        }
        return username;
    }

    public static String stripFormattingCodes(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("(?i)[&\u00a7][0-9A-FK-OR]", "");
    }

    public static Component parseColorsWithPermissions(String text, ServerPlayer player) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        boolean hasColorPerm = Verbatim.permissionService.hasPermission(player, PERM_CHAT_COLOR, 2);
        boolean hasFormatPerm = Verbatim.permissionService.hasPermission(player, PERM_CHAT_FORMAT, 2);
        MutableComponent main = Component.literal((String)"");
        String[] parts = text.split("(?i)(?=&[0-9a-fk-or])");
        Style current = Style.EMPTY;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (part.startsWith("&") && part.length() >= 2) {
                char code = part.charAt(1);
                ChatFormatting fmt = ChatFormatting.getByCode((char)code);
                String content = part.substring(2);
                if (fmt != null) {
                    boolean allow = false;
                    allow = fmt.isColor() ? hasColorPerm : (fmt == ChatFormatting.RESET ? hasColorPerm || hasFormatPerm : hasFormatPerm);
                    if (allow) {
                        current = fmt.isColor() ? Style.EMPTY.withColor(fmt) : (fmt == ChatFormatting.RESET ? Style.EMPTY : ChatFormattingUtils.applyStyle(current, fmt));
                    }
                }
                if (content.isEmpty()) continue;
                main.append((Component)Component.literal((String)content).setStyle(current));
                continue;
            }
            main.append((Component)Component.literal((String)part).setStyle(current));
        }
        return main;
    }

    public static Component parsePlayerInputWithPermissions(String channelBaseColor, String playerInput, ServerPlayer player) {
        if (playerInput == null || playerInput.isEmpty()) {
            return Component.empty();
        }
        Component baseColorComponent = ChatFormattingUtils.parseColors(channelBaseColor);
        Style baseStyle = baseColorComponent.getStyle();
        MutableComponent result = Component.empty();
        boolean hasColorPerm = Verbatim.permissionService.hasPermission(player, PERM_CHAT_COLOR, 2);
        boolean hasFormatPerm = Verbatim.permissionService.hasPermission(player, PERM_CHAT_FORMAT, 2);
        String[] parts = playerInput.split("(?i)(?=&[0-9a-fk-or])");
        Style current = baseStyle;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (part.startsWith("&") && part.length() >= 2) {
                char code = part.charAt(1);
                ChatFormatting fmt = ChatFormatting.getByCode((char)code);
                String content = part.substring(2);
                if (fmt != null) {
                    boolean allow = false;
                    allow = fmt.isColor() ? hasColorPerm : (fmt == ChatFormatting.RESET ? hasColorPerm || hasFormatPerm : hasFormatPerm);
                    if (allow) {
                        current = fmt.isColor() ? Style.EMPTY.withColor(fmt) : (fmt == ChatFormatting.RESET ? baseStyle : ChatFormattingUtils.applyStyle(current, fmt));
                    }
                }
                if (content.isEmpty()) continue;
                result.append((Component)Component.literal((String)content).setStyle(current));
                continue;
            }
            result.append((Component)Component.literal((String)part).setStyle(current));
        }
        return result;
    }
}

