/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.chat;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.ChatChannelManager;
import world.landfall.verbatim.chat.FocusTarget;

public class ChatFocus
extends FocusTarget {
    private final FocusType type;
    private final Object identifier;

    private ChatFocus(FocusType type, Object identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    public static ChatFocus createDmFocus(UUID targetPlayerId) {
        return new ChatFocus(FocusType.DM, targetPlayerId);
    }

    public static ChatFocus createChannelFocus(String channelName) {
        return new ChatFocus(FocusType.CHANNEL, channelName);
    }

    public FocusType getType() {
        return this.type;
    }

    public UUID getTargetPlayerId() {
        return this.type == FocusType.DM ? (UUID)this.identifier : null;
    }

    public String getChannelName() {
        return this.type == FocusType.CHANNEL ? (String)this.identifier : null;
    }

    @Override
    public String getDisplayName() {
        if (this.type == FocusType.DM) {
            ServerPlayer player = ChatChannelManager.getPlayerByUUID((UUID)this.identifier);
            return player != null ? "DM with " + player.getName().getString() : "DM with offline player";
        }
        return ChatChannelManager.getChannelConfigByName((String)this.identifier).map(config -> config.displayPrefix + " " + config.name).orElse("Unknown channel: " + String.valueOf(this.identifier));
    }

    @Override
    public boolean isValid() {
        if (this.type == FocusType.DM) {
            return ChatChannelManager.getPlayerByUUID((UUID)this.identifier) != null;
        }
        return ChatChannelManager.getChannelConfigByName((String)this.identifier).isPresent();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChatFocus)) {
            return false;
        }
        ChatFocus other = (ChatFocus)obj;
        return this.type == other.type && this.identifier.equals(other.identifier);
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.identifier.hashCode();
    }

    public static enum FocusType {
        DM,
        CHANNEL;

    }
}

