/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import world.landfall.verbatim.ChatChannelManager;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.util.NicknameService;

public class VerbatimCommands {
    public static final String PERM_ADMIN_CHLIST = "verbatim.admin.chlist";
    public static final String PERM_ADMIN_CHKICK = "verbatim.admin.chkick";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder listAllChannelsCommand = (LiteralArgumentBuilder)Commands.literal((String)"channels").executes(context -> VerbatimCommands.listChannels((CommandSourceStack)context.getSource()));
        dispatcher.register(listAllChannelsCommand);
        LiteralArgumentBuilder channelCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"channel").then(Commands.literal((String)"help").executes(context -> VerbatimCommands.showHelp((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"list").executes(context -> VerbatimCommands.listChannels((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"focus").then(Commands.argument((String)"channelName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)ChatChannelManager.getAllChannelConfigs().stream().map(c -> c.name).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ChatChannelManager.focusChannel(player, StringArgumentType.getString((CommandContext)context, (String)"channelName"));
            return 1;
        })))).then(Commands.literal((String)"join").then(Commands.argument((String)"channelName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)ChatChannelManager.getAllChannelConfigs().stream().map(c -> c.name).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ChatChannelManager.joinChannel(player, StringArgumentType.getString((CommandContext)context, (String)"channelName"));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"leave").then(Commands.argument((String)"channelName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                return SharedSuggestionProvider.suggest(ChatChannelManager.getJoinedChannels(player), (SuggestionsBuilder)builder);
            }
            return SharedSuggestionProvider.suggest((String[])new String[0], (SuggestionsBuilder)builder);
        }).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ChatChannelManager.leaveChannelCmd(player, StringArgumentType.getString((CommandContext)context, (String)"channelName"));
            return 1;
        }))).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ChatChannelManager.getFocusedChannelConfig(player).ifPresentOrElse(focused -> ChatChannelManager.leaveChannelCmd(player, focused.name), () -> player.sendSystemMessage((Component)Component.literal((String)"You are not focused on any channel to leave.").withStyle(ChatFormatting.YELLOW)));
            return 1;
        }))).executes(context -> VerbatimCommands.showHelp((CommandSourceStack)context.getSource()));
        dispatcher.register(channelCommand);
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"verbatimchannels").redirect((CommandNode)listAllChannelsCommand.build()));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"verbatimchannel").redirect((CommandNode)channelCommand.build()));
        LiteralArgumentBuilder msgCommand = (LiteralArgumentBuilder)Commands.literal((String)"msg").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            if (targets.isEmpty()) {
                sender.sendSystemMessage((Component)Component.literal((String)"No valid player targets.").withStyle(ChatFormatting.RED));
                return 0;
            }
            ChatChannelManager.focusDm(sender, ((ServerPlayer)targets.iterator().next()).getUUID());
            return 1;
        })).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            String message = MessageArgument.getMessage((CommandContext)context, (String)"message").getString();
            int successes = 0;
            for (ServerPlayer target : targets) {
                successes += VerbatimCommands.sendDirectMessage(sender, target, message);
            }
            return successes;
        })));
        LiteralArgumentBuilder tellCommand = (LiteralArgumentBuilder)Commands.literal((String)"tell").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            if (targets.isEmpty()) {
                sender.sendSystemMessage((Component)Component.literal((String)"No valid player targets.").withStyle(ChatFormatting.RED));
                return 0;
            }
            ChatChannelManager.focusDm(sender, ((ServerPlayer)targets.iterator().next()).getUUID());
            return 1;
        })).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            Collection targets = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            String message = MessageArgument.getMessage((CommandContext)context, (String)"message").getString();
            int successes = 0;
            for (ServerPlayer target : targets) {
                successes += VerbatimCommands.sendDirectMessage(sender, target, message);
            }
            return successes;
        })));
        LiteralArgumentBuilder replyCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"r").then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            String message = MessageArgument.getMessage((CommandContext)context, (String)"message").getString();
            return VerbatimCommands.replyToLastDm(sender, message);
        }))).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer sender = (ServerPlayer)patt0$temp;
            ChatChannelManager.handleDPrefix(sender);
            return 1;
        });
        dispatcher.register(msgCommand);
        dispatcher.register(tellCommand);
        dispatcher.register(replyCommand);
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"w").redirect((CommandNode)msgCommand.build()));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> VerbatimCommands.executeCustomListCommand((CommandSourceStack)context.getSource())));
        LiteralArgumentBuilder verbatimListCommand = (LiteralArgumentBuilder)Commands.literal((String)"vlist").executes(context -> VerbatimCommands.listOnlinePlayers((CommandSourceStack)context.getSource()));
        dispatcher.register(verbatimListCommand);
        LiteralArgumentBuilder chListCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chlist").requires(source -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                return Verbatim.permissionService.hasPermission(player, PERM_ADMIN_CHLIST, 2);
            }
            return source.hasPermission(2);
        })).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ArrayList suggestions = new ArrayList();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            if (server != null) {
                server.getPlayerList().getPlayers().forEach(player -> suggestions.add(player.getName().getString()));
            }
            ChatChannelManager.getAllChannelConfigs().forEach(channel -> suggestions.add(channel.name));
            return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
        }).executes(context -> {
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            return VerbatimCommands.executeChList((CommandSourceStack)context.getSource(), targetName);
        }));
        dispatcher.register(chListCommand);
        LiteralArgumentBuilder chKickCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chkick").requires(source -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                return Verbatim.permissionService.hasPermission(player, PERM_ADMIN_CHKICK, 2);
            }
            return source.hasPermission(2);
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"channel", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)ChatChannelManager.getAllChannelConfigs().stream().map(c -> c.name).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> {
            ServerPlayer playerToKick = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            String channelName = StringArgumentType.getString((CommandContext)context, (String)"channel");
            return VerbatimCommands.executeChKick((CommandSourceStack)context.getSource(), playerToKick, channelName);
        })));
        dispatcher.register(chKickCommand);
        LiteralArgumentBuilder nickCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nick").requires(source -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                return Verbatim.permissionService.hasPermission(player, "verbatim.nick", 0);
            }
            return false;
        })).then(Commands.literal((String)"clear").executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            return VerbatimCommands.executeNickClear(player);
        }))).then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            String nickname = StringArgumentType.getString((CommandContext)context, (String)"nickname");
            return VerbatimCommands.executeNickSet(player, nickname);
        }))).executes(context -> {
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Players only."));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            return VerbatimCommands.executeNickShow(player);
        });
        dispatcher.register(nickCommand);
    }

    private static int executeCustomListCommand(CommandSourceStack source) {
        String strippedDisplayName;
        String username;
        MinecraftServer server = source.getServer();
        PlayerList mcPlayerList = server.getPlayerList();
        List onlinePlayers = mcPlayerList.getPlayers();
        if (onlinePlayers.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"There are no players currently online.").withStyle(ChatFormatting.YELLOW), true);
            return 1;
        }
        MutableComponent message = Component.literal((String)("Online Players (" + onlinePlayers.size() + "):")).withStyle(ChatFormatting.GOLD);
        boolean anyPlayerHasCustomDisplayName = false;
        for (ServerPlayer player : onlinePlayers) {
            username = player.getName().getString();
            if (username.equals(strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString()))) continue;
            anyPlayerHasCustomDisplayName = true;
            break;
        }
        for (ServerPlayer player : onlinePlayers) {
            username = player.getName().getString();
            boolean currentPlayerHasCustomDisplayName = !username.equals(strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString()));
            message.append((Component)Component.literal((String)"\n - "));
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + username + " ");
            if (anyPlayerHasCustomDisplayName) {
                if (currentPlayerHasCustomDisplayName) {
                    message.append((Component)Component.literal((String)strippedDisplayName).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(clickEvent)));
                    message.append((Component)Component.literal((String)(" (" + username + ")")).withStyle(ChatFormatting.GRAY));
                    continue;
                }
                message.append((Component)Component.literal((String)username).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withClickEvent(clickEvent)));
                continue;
            }
            message.append((Component)Component.literal((String)username).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(clickEvent)));
        }
        source.sendSuccess(() -> message, true);
        return onlinePlayers.size();
    }

    private static int listOnlinePlayers(CommandSourceStack source) {
        MinecraftServer server = source.getServer();
        PlayerList playerList = server.getPlayerList();
        List onlinePlayers = playerList.getPlayers();
        if (onlinePlayers.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"There are no players currently online. (vlist)").withStyle(ChatFormatting.YELLOW), true);
            return 1;
        }
        MutableComponent message = Component.literal((String)("Online Players (" + onlinePlayers.size() + ") [vlist]:\n")).withStyle(ChatFormatting.GOLD);
        for (ServerPlayer player : onlinePlayers) {
            String username = player.getName().getString();
            String strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString());
            Object formattedName = username;
            if (!username.equals(strippedDisplayName)) {
                formattedName = strippedDisplayName + " (" + username + ")";
            }
            message.append((Component)Component.literal((String)(" - " + (String)formattedName + "\n")).withStyle(ChatFormatting.GREEN));
        }
        source.sendSuccess(() -> message, true);
        return onlinePlayers.size();
    }

    private static int listChannels(CommandSourceStack source) {
        MutableComponent message = Component.literal((String)"Available Channels (Focusable/Joinable):\n").withStyle(ChatFormatting.GOLD);
        Collection<ChatChannelManager.ChannelConfig> allChannels = ChatChannelManager.getAllChannelConfigs();
        if (allChannels.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No chat channels are currently configured.").withStyle(ChatFormatting.RED));
            return 0;
        }
        for (ChatChannelManager.ChannelConfig channelConfig : allChannels) {
            message.append(ChatFormattingUtils.parseColors(channelConfig.displayPrefix)).append((Component)Component.literal((String)(" " + channelConfig.name)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)(" (Shortcut: " + channelConfig.shortcut + ")")).withStyle(ChatFormatting.GRAY));
            if (channelConfig.range >= 0) {
                message.append((Component)Component.literal((String)" - Range: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(channelConfig.range)).withStyle(ChatFormatting.AQUA));
            }
            if (channelConfig.alwaysOn) {
                message.append((Component)Component.literal((String)" (Always On, Public)").withStyle(ChatFormatting.DARK_GRAY));
            } else if (channelConfig.permission.isEmpty()) {
                message.append((Component)Component.literal((String)" (Public)").withStyle(ChatFormatting.GREEN));
            } else {
                message.append((Component)Component.literal((String)" (Permission: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)channelConfig.permission.get()).withStyle(ChatFormatting.ITALIC)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.GRAY));
            }
            message.append("\n");
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Set<String> set = ChatChannelManager.getJoinedChannels(player);
            ChatChannelManager.getFocusedChannelConfig(player).ifPresent(focused -> message.append((Component)Component.literal((String)"\nYour Focused Channel: ").withStyle(ChatFormatting.BLUE)).append(ChatFormattingUtils.parseColors(focused.displayPrefix)).append((Component)Component.literal((String)(" " + focused.name)).withStyle(ChatFormatting.BOLD)));
            if (!set.isEmpty()) {
                message.append((Component)Component.literal((String)"\nYour Joined Channels:\n").withStyle(ChatFormatting.BLUE));
                for (String joinedName : set) {
                    ChatChannelManager.getChannelConfigByName(joinedName).ifPresent(jc -> message.append("  - ").append(ChatFormattingUtils.parseColors(jc.displayPrefix)).append((Component)Component.literal((String)(" " + jc.name)).withStyle(ChatFormatting.DARK_AQUA)).append("\n"));
                }
            }
        }
        source.sendSuccess(() -> message, false);
        return 1;
    }

    private static int showHelp(CommandSourceStack source) {
        MutableComponent helpMessage = Component.literal((String)"Verbatim Channel Commands:\n").withStyle(ChatFormatting.GOLD);
        helpMessage.append("/channels or /channel list - Lists all available channels & your status.\n");
        helpMessage.append("/channel focus <channelName> - Sets your active typing channel (also joins it).\n");
        helpMessage.append("/channel join <channelName> - Joins a channel to receive messages.\n");
        helpMessage.append("/channel leave <channelName> - Leaves a joined channel.\n");
        helpMessage.append("/channel leave - Leaves your currently focused channel (if not alwaysOn).\n");
        helpMessage.append("/channel help - Shows this help message.\n\n");
        helpMessage.append((Component)Component.literal((String)"Direct Message Commands:\n").withStyle(ChatFormatting.AQUA));
        helpMessage.append("/msg <player> [message] - Focus DM with player (and send message if provided).\n");
        helpMessage.append("/tell <player> [message] - Same as /msg.\n");
        helpMessage.append("/r [message] - Reply to last DM sender (and send message if provided).\n\n");
        helpMessage.append((Component)Component.literal((String)"Chat Prefixes:\n").withStyle(ChatFormatting.GREEN));
        helpMessage.append("d: - Focus on last DM sender (same as /r without message).\n");
        helpMessage.append("g: - Switch to global chat.\n");
        helpMessage.append((Component)Component.literal((String)"Use shortcuts like ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"g: your message").withStyle(ChatFormatting.ITALIC)).append((Component)Component.literal((String)" to send to global (if shortcut is 'g') and focus it.").withStyle(ChatFormatting.GRAY));
        source.sendSuccess(() -> helpMessage, false);
        return 1;
    }

    private static int sendDirectMessage(ServerPlayer sender, ServerPlayer target, String message) {
        ChatChannelManager.focusDm(sender, target.getUUID());
        ChatChannelManager.setLastIncomingDmSender(target, sender.getUUID());
        MutableComponent senderMessage = Component.literal((String)"[You -> ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)target.getName().getString()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"]: ").withStyle(ChatFormatting.LIGHT_PURPLE)).append(ChatFormattingUtils.parsePlayerInputWithPermissions("&f", message, sender));
        MutableComponent recipientMessage = Component.literal((String)"[").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)sender.getName().getString()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" -> You]: ").withStyle(ChatFormatting.LIGHT_PURPLE)).append(ChatFormattingUtils.parsePlayerInputWithPermissions("&f", message, sender));
        sender.sendSystemMessage((Component)senderMessage);
        target.sendSystemMessage((Component)recipientMessage);
        Verbatim.LOGGER.debug("[Verbatim DM Command] DM sent from {} to {}: {}", new Object[]{sender.getName().getString(), target.getName().getString(), message});
        return 1;
    }

    private static int replyToLastDm(ServerPlayer sender, String message) {
        Optional<UUID> lastSenderOpt = ChatChannelManager.getLastIncomingDmSender(sender);
        if (lastSenderOpt.isEmpty()) {
            sender.sendSystemMessage((Component)Component.literal((String)"No recent DMs to reply to.").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        ServerPlayer target = ChatChannelManager.getPlayerByUUID(lastSenderOpt.get());
        if (target == null) {
            sender.sendSystemMessage((Component)Component.literal((String)"Cannot reply: Target player is not online.").withStyle(ChatFormatting.RED));
            return 0;
        }
        return VerbatimCommands.sendDirectMessage(sender, target, message);
    }

    private static int executeChList(CommandSourceStack source, String targetName) {
        MinecraftServer server = source.getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer != null) {
            Set<String> joinedChannels = ChatChannelManager.getJoinedChannels(targetPlayer);
            if (joinedChannels.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)(targetPlayer.getName().getString() + " is not in any channels.")).withStyle(ChatFormatting.YELLOW), false);
                return 1;
            }
            MutableComponent message = Component.literal((String)("Channels for " + targetPlayer.getName().getString() + ":\n")).withStyle(ChatFormatting.GOLD);
            for (String channelName : joinedChannels) {
                ChatChannelManager.getChannelConfigByName(channelName).ifPresent(config -> message.append((Component)Component.literal((String)(" - " + config.name)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" (" + config.displayPrefix + ")\n")).withStyle(ChatFormatting.GRAY)));
            }
            source.sendSuccess(() -> message, false);
        } else {
            Optional<ChatChannelManager.ChannelConfig> channelConfigOpt = ChatChannelManager.getChannelConfigByName(targetName);
            if (channelConfigOpt.isPresent()) {
                ChatChannelManager.ChannelConfig channelConfig = channelConfigOpt.get();
                List<ServerPlayer> playersInChannel = ChatChannelManager.getPlayersInChannel(server, targetName);
                if (playersInChannel.isEmpty()) {
                    source.sendSuccess(() -> Component.literal((String)("No players are in channel " + channelConfig.name + ".")).withStyle(ChatFormatting.YELLOW), false);
                    return 1;
                }
                MutableComponent message = Component.literal((String)("Players in channel " + channelConfig.name + ":\n")).withStyle(ChatFormatting.GOLD);
                for (ServerPlayer p : playersInChannel) {
                    message.append((Component)Component.literal((String)(" - " + p.getName().getString() + "\n")).withStyle(ChatFormatting.AQUA));
                }
                source.sendSuccess(() -> message, false);
            } else {
                source.sendFailure((Component)Component.literal((String)("Target '" + targetName + "' is not a valid online player or channel name.")));
                return 0;
            }
        }
        return 1;
    }

    private static int executeChKick(CommandSourceStack source, ServerPlayer playerToKick, String channelName) {
        boolean success = ChatChannelManager.adminKickPlayerFromChannel(playerToKick, channelName, source.getPlayer());
        if (success) {
            source.sendSuccess(() -> Component.literal((String)("Kicked " + playerToKick.getName().getString() + " from channel " + channelName + ".")).withStyle(ChatFormatting.GREEN), true);
        } else if (!ChatChannelManager.getChannelConfigByName(channelName).map(c -> c.alwaysOn).orElse(false).booleanValue()) {
            source.sendFailure((Component)Component.literal((String)("Failed to kick " + playerToKick.getName().getString() + " from " + channelName + ". Player might not be in it or channel is always-on.")));
        }
        return success ? 1 : 0;
    }

    private static int executeNickShow(ServerPlayer player) {
        String currentNickname = NicknameService.getNickname(player);
        if (currentNickname != null) {
            MutableComponent message = Component.literal((String)"Your current nickname: ").withStyle(ChatFormatting.YELLOW);
            message.append(ChatFormattingUtils.parseColors(currentNickname));
            player.sendSystemMessage((Component)message);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"You don't have a nickname set.").withStyle(ChatFormatting.YELLOW));
        }
        return 1;
    }

    private static int executeNickSet(ServerPlayer player, String nickname) {
        if (nickname.length() > 64) {
            player.sendSystemMessage((Component)Component.literal((String)"Nickname is too long. Maximum 64 characters.").withStyle(ChatFormatting.RED));
            return 0;
        }
        String processedNickname = NicknameService.setNickname(player, nickname);
        if (processedNickname != null) {
            MutableComponent message = Component.literal((String)"Nickname set to: ").withStyle(ChatFormatting.GREEN);
            message.append(ChatFormattingUtils.parseColors(processedNickname));
            player.sendSystemMessage((Component)message);
            if (!processedNickname.equals(nickname)) {
                player.sendSystemMessage((Component)Component.literal((String)"Note: Color codes were removed due to missing permissions.").withStyle(ChatFormatting.GRAY));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"Failed to set nickname.").withStyle(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int executeNickClear(ServerPlayer player) {
        if (NicknameService.hasNickname(player)) {
            NicknameService.clearNickname(player);
            player.sendSystemMessage((Component)Component.literal((String)"Nickname cleared.").withStyle(ChatFormatting.GREEN));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"You don't have a nickname set.").withStyle(ChatFormatting.YELLOW));
        }
        return 1;
    }
}

