/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.discord;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.VerbatimConfig;
import world.landfall.verbatim.discord.DiscordListener;

public class DiscordBot {
    private static final Map<UUID, Color> SPECIAL_UUID_COLORS = new HashMap<UUID, Color>();
    private static JDA jdaInstance;
    private static String discordChannelId;
    private static boolean enabled;
    private static boolean useEmbedMode;
    private static ScheduledExecutorService presenceScheduler;

    public static void init() {
        enabled = (Boolean)VerbatimConfig.DISCORD_BOT_ENABLED.get();
        useEmbedMode = (Boolean)VerbatimConfig.DISCORD_USE_EMBED_MODE.get();
        if (!enabled) {
            Verbatim.LOGGER.info("[Verbatim Discord] Bot is disabled in config.");
            return;
        }
        String botToken = (String)VerbatimConfig.DISCORD_BOT_TOKEN.get();
        discordChannelId = (String)VerbatimConfig.DISCORD_CHANNEL_ID.get();
        if (botToken == null || botToken.isEmpty() || botToken.equals("YOUR_DISCORD_BOT_TOKEN_HERE")) {
            Verbatim.LOGGER.error("[Verbatim Discord] Bot token is not configured. Discord bot will not start.");
            return;
        }
        if (discordChannelId == null || discordChannelId.isEmpty() || discordChannelId.equals("YOUR_DISCORD_CHANNEL_ID_HERE")) {
            Verbatim.LOGGER.error("[Verbatim Discord] Discord channel ID is not configured. Discord bot will not start.");
            return;
        }
        try {
            jdaInstance = JDABuilder.createDefault((String)botToken).enableIntents(GatewayIntent.GUILD_MESSAGES, new GatewayIntent[]{GatewayIntent.MESSAGE_CONTENT}).setMemberCachePolicy(MemberCachePolicy.NONE).addEventListeners(new Object[]{new DiscordListener()}).build();
            jdaInstance.awaitReady();
            Verbatim.LOGGER.info("[Verbatim Discord] Bot connected and ready!");
            jdaInstance.upsertCommand("list", "Lists online players on the Minecraft server.").queue();
            Verbatim.LOGGER.info("[Verbatim Discord] /list slash command registered/updated.");
            DiscordBot.updatePlayerCountStatus();
            presenceScheduler = Executors.newSingleThreadScheduledExecutor();
            presenceScheduler.scheduleAtFixedRate(DiscordBot::updatePlayerCountStatus, 1L, 1L, TimeUnit.MINUTES);
            Verbatim.LOGGER.info("[Verbatim Discord] Presence update scheduler started.");
        }
        catch (InterruptedException e) {
            Verbatim.LOGGER.error("[Verbatim Discord] JDA initialization was interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            jdaInstance = null;
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[Verbatim Discord] Failed to initialize JDA or log in.", (Throwable)e);
            jdaInstance = null;
        }
    }

    public static void shutdown() {
        if (presenceScheduler != null && !presenceScheduler.isShutdown()) {
            presenceScheduler.shutdown();
            try {
                if (!presenceScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    presenceScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                presenceScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            Verbatim.LOGGER.info("[Verbatim Discord] Presence update scheduler shut down.");
        }
        if (jdaInstance != null) {
            Verbatim.LOGGER.info("[Verbatim Discord] Shutting down Discord bot...");
            jdaInstance.shutdown();
            try {
                if (!jdaInstance.awaitShutdown(10L, TimeUnit.SECONDS)) {
                    Verbatim.LOGGER.warn("[Verbatim Discord] Bot did not shut down in 10 seconds, forcing shutdown.");
                    jdaInstance.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Verbatim.LOGGER.error("[Verbatim Discord] Interrupted while awaiting bot shutdown.", (Throwable)e);
                jdaInstance.shutdownNow();
                Thread.currentThread().interrupt();
            }
            Verbatim.LOGGER.info("[Verbatim Discord] Bot has been shut down.");
            jdaInstance = null;
        }
    }

    public static void sendToDiscord(String message) {
        if (jdaInstance == null || discordChannelId == null || !enabled) {
            return;
        }
        try {
            TextChannel channel = jdaInstance.getTextChannelById(discordChannelId);
            if (channel != null) {
                channel.sendMessage((CharSequence)message).queue();
                Verbatim.LOGGER.debug("[Verbatim Discord Generic] Relayed: {}", (Object)message);
            } else {
                Verbatim.LOGGER.warn("[Verbatim Discord] Configured Discord channel ID '{}' not found for generic message.", (Object)discordChannelId);
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[Verbatim Discord] Could not send generic message to Discord.", (Throwable)e);
        }
    }

    private static Color generateColorFromUUID(UUID uuid) {
        if (SPECIAL_UUID_COLORS.containsKey(uuid)) {
            return SPECIAL_UUID_COLORS.get(uuid);
        }
        int hash = uuid.hashCode();
        float hue = (float)(Math.abs(hash) % 360) / 360.0f;
        return Color.getHSBColor(hue, 0.7f, 0.85f);
    }

    private static String getPlayerAvatarUrl(ServerPlayer player) {
        String username = player.getName().getString();
        return "https://minotar.net/avatar/" + username;
    }

    public static void sendPlayerChatMessageToDiscord(ServerPlayer player, String messageContent) {
        if (!DiscordBot.isEnabled()) {
            return;
        }
        try {
            TextChannel channel = jdaInstance.getTextChannelById(discordChannelId);
            if (channel == null) {
                Verbatim.LOGGER.warn("[Verbatim Discord] Configured Discord channel ID '{}' not found for player message.", (Object)discordChannelId);
                return;
            }
            String username = player.getName().getString();
            String strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString());
            String cleanMessageContent = ChatFormattingUtils.stripFormattingCodes(messageContent);
            if (useEmbedMode) {
                String avatarUrl = DiscordBot.getPlayerAvatarUrl(player);
                Object authorName = username;
                if (!username.equals(strippedDisplayName)) {
                    authorName = strippedDisplayName + " (" + username + ")";
                }
                EmbedBuilder embed = new EmbedBuilder();
                embed.setAuthor((String)authorName, null, avatarUrl);
                embed.setDescription((CharSequence)cleanMessageContent);
                embed.setColor(DiscordBot.generateColorFromUUID(player.getUUID()));
                channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
                Verbatim.LOGGER.debug("[Game -> Discord Embed] Relayed for {}: {}", authorName, (Object)cleanMessageContent);
            } else {
                String plainTextMessage = username + ": " + cleanMessageContent;
                channel.sendMessage((CharSequence)plainTextMessage).queue();
                Verbatim.LOGGER.debug("[Game -> Discord Plain] Relayed for {}: {}", (Object)username, (Object)cleanMessageContent);
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[Verbatim Discord] Could not send player chat message to Discord for {}.", (Object)player.getName().getString(), (Object)e);
        }
    }

    public static void sendPlayerConnectionStatusToDiscord(ServerPlayer player, boolean joined) {
        if (!DiscordBot.isEnabled()) {
            return;
        }
        try {
            TextChannel channel = jdaInstance.getTextChannelById(discordChannelId);
            if (channel == null) {
                Verbatim.LOGGER.warn("[Verbatim Discord] Configured Discord channel ID '{}' not found for connection status.", (Object)discordChannelId);
                return;
            }
            String username = player.getName().getString();
            String strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString());
            Object effectiveName = username;
            if (!username.equals(strippedDisplayName)) {
                effectiveName = strippedDisplayName + " (" + username + ")";
            }
            if (useEmbedMode) {
                String avatarUrl = DiscordBot.getPlayerAvatarUrl(player);
                EmbedBuilder embed = new EmbedBuilder();
                embed.setColor(joined ? new Color(5025616) : new Color(16007990));
                embed.setAuthor((String)effectiveName + (joined ? " has joined the server." : " has left the server."), null, avatarUrl);
                channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
                Verbatim.LOGGER.debug("[Game -> Discord Embed] Connection Status: {} {}", effectiveName, (Object)(joined ? "joined" : "left"));
            } else {
                String statusEmoji = joined ? "\u2795" : "\u2796";
                String plainTextMessage = statusEmoji + " " + username + " has " + (joined ? "joined" : "left") + " the server.";
                channel.sendMessage((CharSequence)plainTextMessage).queue();
                Verbatim.LOGGER.debug("[Game -> Discord Plain] Connection Status: {} {}", (Object)username, (Object)(joined ? "joined" : "left"));
            }
            DiscordBot.updatePlayerCountStatus();
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[Verbatim Discord] Could not send player connection status to Discord for {}.", (Object)player.getName().getString(), (Object)e);
        }
    }

    public static String getDiscordMessagePrefix() {
        return (String)VerbatimConfig.DISCORD_MESSAGE_PREFIX.get();
    }

    public static String getDiscordMessageSeparator() {
        return (String)VerbatimConfig.DISCORD_MESSAGE_SEPARATOR.get();
    }

    public static boolean isEnabled() {
        return enabled && jdaInstance != null;
    }

    public static void updatePlayerCountStatus() {
        int playerCount;
        if (jdaInstance == null || !jdaInstance.getStatus().isInit()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Object statusMessage = server != null ? ((playerCount = server.getPlayerList().getPlayerCount()) == 1 ? "1 player online" : playerCount + " players online") : "Server Offline";
        try {
            jdaInstance.getPresence().setActivity(Activity.watching((String)statusMessage));
        }
        catch (Exception e) {
            Verbatim.LOGGER.warn("[Verbatim Discord] Could not update bot presence: {}", (Object)e.getMessage());
        }
    }

    static {
        SPECIAL_UUID_COLORS.put(UUID.fromString("7755ac32-2fba-4ef6-a85b-93c354267a91"), new Color(155, 89, 182));
        SPECIAL_UUID_COLORS.put(UUID.fromString("886f738d-8d9a-4ba9-9148-af80e82dd744"), new Color(130, 35, 109));
    }
}

