/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.discord;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.VerbatimConfig;
import world.landfall.verbatim.discord.DiscordBot;

public class DiscordListener
extends ListenerAdapter {
    public void onMessageReceived(@Nonnull MessageReceivedEvent event) {
        MinecraftServer server;
        String separatorStr;
        String originalMessageContent;
        if (!DiscordBot.isEnabled()) {
            return;
        }
        User author = event.getAuthor();
        if (author.isBot() || author.isSystem()) {
            return;
        }
        String configuredChannelId = (String)VerbatimConfig.DISCORD_CHANNEL_ID.get();
        if (!event.getChannel().getId().equals(configuredChannelId)) {
            return;
        }
        String processedContent = originalMessageContent = event.getMessage().getContentRaw().replace("[", "\\[").replace("]", "\\]");
        for (CustomEmoji emoji : event.getMessage().getMentions().getCustomEmojis()) {
            String emojiMention = emoji.getAsMention();
            String emojiName = ":" + emoji.getName() + ":";
            processedContent = processedContent.replace(emojiMention, emojiName);
        }
        if (processedContent.trim().isEmpty() && event.getMessage().getAttachments().isEmpty()) {
            return;
        }
        Member member = event.getMember();
        String nickname = member != null ? member.getNickname() : null;
        String authorName = nickname != null && !nickname.isEmpty() ? nickname : author.getName();
        String prefixStr = DiscordBot.getDiscordMessagePrefix();
        if (prefixStr == null) {
            prefixStr = "";
        }
        if ((separatorStr = DiscordBot.getDiscordMessageSeparator()) == null) {
            separatorStr = ": ";
        }
        MutableComponent finalMessage = Component.empty();
        int currentLength = 0;
        int MAX_LENGTH = 256;
        String TRUNCATION_MARKER = "...";
        int TRUNCATION_MARKER_LEN = "...".length();
        if (!prefixStr.isEmpty()) {
            Component prefixComponent = ChatFormattingUtils.parseColors(prefixStr + " ");
            finalMessage.append(prefixComponent);
            currentLength += ChatFormattingUtils.stripFormattingCodes(prefixComponent.getString()).length();
        }
        finalMessage.append((Component)Component.literal((String)authorName));
        currentLength += authorName.length();
        finalMessage.append(ChatFormattingUtils.parseColors(separatorStr));
        int remainingLength = 256 - (currentLength += ChatFormattingUtils.stripFormattingCodes(separatorStr).length()) - TRUNCATION_MARKER_LEN;
        String contentStr = processedContent.trim();
        if (!contentStr.isEmpty()) {
            if (contentStr.length() > remainingLength) {
                contentStr = contentStr.substring(0, remainingLength);
                finalMessage.append((Component)Component.literal((String)contentStr));
                finalMessage.append((Component)Component.literal((String)"...").withStyle(ChatFormatting.DARK_GRAY));
                remainingLength = 0;
            } else {
                finalMessage.append((Component)Component.literal((String)contentStr));
                if (!event.getMessage().getAttachments().isEmpty() && (remainingLength -= contentStr.length()) > 1) {
                    finalMessage.append((Component)Component.literal((String)" "));
                    --remainingLength;
                }
            }
        }
        if (remainingLength > 0) {
            List attachments = event.getMessage().getAttachments();
            for (Message.Attachment attachment : attachments) {
                String fileName = attachment.getFileName();
                String proxyUrl = attachment.getProxyUrl();
                if (fileName.length() + 2 > remainingLength) {
                    finalMessage.append((Component)Component.literal((String)"...").withStyle(ChatFormatting.DARK_GRAY));
                    break;
                }
                MutableComponent attachmentComponent = Component.literal((String)("[" + fileName + "]")).withStyle(style -> style.withColor(ChatFormatting.DARK_GRAY).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, proxyUrl)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to open " + fileName)))));
                finalMessage.append((Component)attachmentComponent);
                if (attachments.indexOf(attachment) >= attachments.size() - 1 || (remainingLength -= fileName.length() + 2) <= 1) continue;
                finalMessage.append((Component)Component.literal((String)" "));
                --remainingLength;
            }
        }
        if ((server = ServerLifecycleHooks.getCurrentServer()) != null) {
            server.getPlayerList().broadcastSystemMessage((Component)finalMessage, false);
            Verbatim.LOGGER.debug("[Discord -> Game] {} ({}) relayed to game chat.", (Object)authorName, (Object)author.getId());
        } else {
            Verbatim.LOGGER.warn("[Verbatim Discord] MinecraftServer instance is null, cannot send message to game.");
        }
    }

    public void onSlashCommandInteraction(@Nonnull SlashCommandInteractionEvent event) {
        if (!DiscordBot.isEnabled()) {
            event.reply("The Discord bot integration is currently disabled.").setEphemeral(true).queue();
            return;
        }
        if (event.getName().equals("list")) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                event.reply("Could not connect to the Minecraft server to fetch the player list.").setEphemeral(true).queue();
                return;
            }
            PlayerList mcPlayerList = server.getPlayerList();
            List onlinePlayers = mcPlayerList.getPlayers();
            if (onlinePlayers.isEmpty()) {
                event.reply("There are no players currently online on the Minecraft server.").setEphemeral(true).queue();
                return;
            }
            Object playerListString = onlinePlayers.stream().map(player -> {
                String strippedDisplayName;
                String username = player.getName().getString();
                if (!username.equals(strippedDisplayName = ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString()))) {
                    return strippedDisplayName + " (" + username + ")";
                }
                return username;
            }).collect(Collectors.joining("\n- ", "**Online Players (" + onlinePlayers.size() + "):**\n- ", ""));
            if (((String)playerListString).length() > 1990) {
                playerListString = ((String)playerListString).substring(0, 1990) + "... (list truncated)";
            }
            event.reply((String)playerListString).setEphemeral(true).queue();
        }
    }
}

