/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.specialchannels;

import net.minecraft.network.chat.MutableComponent;
import world.landfall.verbatim.specialchannels.LocalChannelFormatter;

public class FormattedMessageDetails {
    public final MutableComponent formattedMessage;
    public final int effectiveRange;
    private final boolean isRoleplayMessage;
    private final String channelMessageColorForObscuring;

    public FormattedMessageDetails(MutableComponent formattedMessage, int effectiveRange, boolean isRoleplayMessage, String channelMessageColorForObscuring) {
        this.formattedMessage = formattedMessage;
        this.effectiveRange = effectiveRange;
        this.isRoleplayMessage = isRoleplayMessage;
        this.channelMessageColorForObscuring = channelMessageColorForObscuring;
    }

    public MutableComponent getMessageForDistance(double distanceSquared) {
        if (this.effectiveRange < 0) {
            return this.formattedMessage.copy();
        }
        double distance = Math.sqrt(distanceSquared);
        if (distance <= (double)this.effectiveRange) {
            return this.formattedMessage.copy();
        }
        double fadeDistance = this.effectiveRange <= 15 ? (double)this.effectiveRange * 2.0 : Math.min(30.0, (double)this.effectiveRange * 0.6);
        if (distance <= (double)this.effectiveRange + fadeDistance) {
            return LocalChannelFormatter.createDistanceObscuredMessage(this.formattedMessage, distanceSquared, this.effectiveRange, this.isRoleplayMessage, this.channelMessageColorForObscuring);
        }
        return null;
    }
}

