/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.specialchannels;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.ChatChannelManager;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.specialchannels.FormattedMessageDetails;

public class LocalChannelFormatter {
    private static final Random RANDOM = new Random();
    private static final int MAX_FADE_DISTANCE = 15;
    private static final String OBSCURE_CHARS = ".";

    public static MutableComponent createDistanceObscuredMessage(MutableComponent originalMessage, double distanceSquared, int effectiveRange, boolean isRoleplayMessage, String channelMessageColorString) {
        int i;
        if (isRoleplayMessage || effectiveRange < 0) {
            return originalMessage.copy();
        }
        double distance = Math.sqrt(distanceSquared);
        if (distance <= (double)effectiveRange) {
            return originalMessage.copy();
        }
        double fadeDistance = effectiveRange <= 15 ? (double)effectiveRange * 1.5 : Math.min(15.0, (double)effectiveRange * 0.3);
        double obscurePercentage = (distance - (double)effectiveRange) / fadeDistance;
        obscurePercentage = Math.min(1.0, Math.max(0.0, obscurePercentage));
        List originalSiblings = originalMessage.getSiblings();
        if (originalSiblings.isEmpty()) {
            return originalMessage.copy();
        }
        MutableComponent reconstructedMessage = Component.empty();
        int firstMessageContentComponentIndex = -1;
        if (originalSiblings.size() > 0) {
            firstMessageContentComponentIndex = originalSiblings.size() - 1;
        }
        if (firstMessageContentComponentIndex == -1) {
            return originalMessage.copy();
        }
        for (i = 0; i < firstMessageContentComponentIndex; ++i) {
            reconstructedMessage.append((Component)((Component)originalSiblings.get(i)).copy());
        }
        for (i = firstMessageContentComponentIndex; i < originalSiblings.size(); ++i) {
            Component messagePartComponent = (Component)originalSiblings.get(i);
            String textToObscure = messagePartComponent.getString();
            for (char c : textToObscure.toCharArray()) {
                if (RANDOM.nextDouble() < obscurePercentage) {
                    reconstructedMessage.append((Component)Component.literal((String)String.valueOf(OBSCURE_CHARS.charAt(RANDOM.nextInt(OBSCURE_CHARS.length())))).withStyle(ChatFormatting.DARK_GRAY));
                    continue;
                }
                reconstructedMessage.append(ChatFormattingUtils.parseColors(channelMessageColorString + c));
            }
        }
        return reconstructedMessage;
    }

    public static Optional<FormattedMessageDetails> formatLocalMessage(ServerPlayer sender, ChatChannelManager.ChannelConfig channelConfig, String originalMessageContent) {
        boolean isLocalSpecialChannel = channelConfig.specialChannelType.map("local"::equals).orElse(false);
        if (!isLocalSpecialChannel) {
            return Optional.empty();
        }
        int effectiveRange = 50;
        String localActionText = "says:";
        String actualMessageContent = originalMessageContent;
        boolean applyPlusStyleFormatting = false;
        String messageAfterSuffixRemoval = originalMessageContent;
        if (originalMessageContent.endsWith("!!")) {
            effectiveRange = 100;
            localActionText = "shouts:";
            messageAfterSuffixRemoval = originalMessageContent;
        } else if (originalMessageContent.endsWith("!")) {
            effectiveRange = 75;
            localActionText = "exclaims:";
            messageAfterSuffixRemoval = originalMessageContent;
        } else if (originalMessageContent.endsWith("*")) {
            effectiveRange = 10;
            localActionText = "whispers:";
            messageAfterSuffixRemoval = originalMessageContent.substring(0, originalMessageContent.length() - 1);
        } else if (originalMessageContent.endsWith("?")) {
            effectiveRange = 50;
            localActionText = "asks:";
            messageAfterSuffixRemoval = originalMessageContent;
        } else if (originalMessageContent.endsWith("$")) {
            effectiveRange = 3;
            localActionText = "mutters:";
            messageAfterSuffixRemoval = originalMessageContent.substring(0, originalMessageContent.length() - 1);
        } else if (originalMessageContent.endsWith("+")) {
            effectiveRange = 50;
            localActionText = "";
            applyPlusStyleFormatting = true;
            messageAfterSuffixRemoval = originalMessageContent.substring(0, originalMessageContent.length() - 1);
        } else if (originalMessageContent.endsWith("))")) {
            effectiveRange = 50;
            localActionText = "";
            applyPlusStyleFormatting = false;
            messageAfterSuffixRemoval = originalMessageContent.substring(0, originalMessageContent.length() - 2);
            MutableComponent finalMessage = Component.empty();
            finalMessage.append((Component)Component.literal((String)"[OOC] ").withStyle(ChatFormatting.DARK_GRAY));
            String playerName = sender.getName().getString();
            String displayName = sender.getDisplayName().getString();
            finalMessage.append((Component)Component.literal((String)(playerName + " (" + displayName + "): ")).withStyle(ChatFormatting.DARK_GRAY));
            finalMessage.append(ChatFormattingUtils.parseColors("&8" + messageAfterSuffixRemoval.trim()));
            return Optional.of(new FormattedMessageDetails(finalMessage, effectiveRange, false, "&8"));
        }
        actualMessageContent = messageAfterSuffixRemoval.trim();
        MutableComponent finalMessage = Component.empty();
        finalMessage.append(ChatFormattingUtils.parseColors(channelConfig.displayPrefix));
        finalMessage.append((Component)Component.literal((String)" "));
        Component playerNameComponent = ChatFormattingUtils.createPlayerNameComponent(sender, channelConfig.nameColor, false, channelConfig.nameStyle);
        finalMessage.append(playerNameComponent);
        finalMessage.append((Component)Component.literal((String)" "));
        if (!localActionText.isEmpty()) {
            finalMessage.append((Component)Component.literal((String)localActionText));
            finalMessage.append((Component)Component.literal((String)" "));
        }
        if (applyPlusStyleFormatting) {
            LocalChannelFormatter.formatPlusStyleMessage(finalMessage, actualMessageContent, channelConfig.messageColor);
            return Optional.of(new FormattedMessageDetails(finalMessage, effectiveRange, true, null));
        }
        finalMessage.append(ChatFormattingUtils.parseColors(channelConfig.messageColor + actualMessageContent));
        return Optional.of(new FormattedMessageDetails(finalMessage, effectiveRange, false, channelConfig.messageColor));
    }

    private static void formatPlusStyleMessage(MutableComponent finalMessage, String messageContent, String baseColorPrefix) {
        boolean inQuote = false;
        StringBuilder currentSegment = new StringBuilder();
        for (int i = 0; i < messageContent.length(); ++i) {
            char c = messageContent.charAt(i);
            if (c == '\"') {
                if (currentSegment.length() > 0) {
                    if (inQuote) {
                        finalMessage.append((Component)Component.literal((String)currentSegment.toString()).copy().withStyle(ChatFormatting.GRAY));
                    } else {
                        finalMessage.append((Component)Component.literal((String)currentSegment.toString()).copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
                    }
                    currentSegment.setLength(0);
                }
                finalMessage.append((Component)Component.literal((String)"\"").copy().withStyle(ChatFormatting.GRAY));
                inQuote = !inQuote;
                continue;
            }
            currentSegment.append(c);
        }
        if (currentSegment.length() > 0) {
            if (inQuote) {
                finalMessage.append((Component)Component.literal((String)currentSegment.toString()).copy().withStyle(ChatFormatting.GRAY));
            } else {
                finalMessage.append((Component)Component.literal((String)currentSegment.toString()).copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
            }
        }
    }
}

