/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.NameStyle;
import world.landfall.verbatim.Verbatim;

public class NicknameService {
    public static final String PERM_NICK = "verbatim.nick";
    private static final String NBT_NICKNAME_KEY = "verbatim_nickname";
    private static final Map<UUID, String> nicknameCache = new HashMap<UUID, String>();

    public static String setNickname(ServerPlayer player, String nickname) {
        if (nickname == null || nickname.trim().isEmpty()) {
            NicknameService.clearNickname(player);
            return null;
        }
        String processedNickname = Verbatim.permissionService.hasPermission(player, "verbatim.chatcolor", 2) || Verbatim.permissionService.hasPermission(player, "verbatim.chatformat", 2) ? nickname : ChatFormattingUtils.stripFormattingCodes(nickname);
        CompoundTag persistentData = player.getPersistentData();
        persistentData.putString(NBT_NICKNAME_KEY, processedNickname);
        nicknameCache.put(player.getUUID(), processedNickname);
        Verbatim.LOGGER.debug("Set nickname for player {} to: {}", (Object)player.getName().getString(), (Object)processedNickname);
        return processedNickname;
    }

    public static String getNickname(ServerPlayer player) {
        UUID playerId = player.getUUID();
        if (nicknameCache.containsKey(playerId)) {
            return nicknameCache.get(playerId);
        }
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.contains(NBT_NICKNAME_KEY)) {
            String nickname = persistentData.getString(NBT_NICKNAME_KEY);
            nicknameCache.put(playerId, nickname);
            return nickname;
        }
        return null;
    }

    public static void clearNickname(ServerPlayer player) {
        UUID playerId = player.getUUID();
        CompoundTag persistentData = player.getPersistentData();
        persistentData.remove(NBT_NICKNAME_KEY);
        nicknameCache.remove(playerId);
        Verbatim.LOGGER.debug("Cleared nickname for player {}", (Object)player.getName().getString());
    }

    public static boolean hasNickname(ServerPlayer player) {
        return NicknameService.getNickname(player) != null;
    }

    public static void onPlayerLogout(UUID playerId) {
        nicknameCache.remove(playerId);
    }

    public static String getNameForStyle(ServerPlayer player, NameStyle nameStyle) {
        switch (nameStyle) {
            case USERNAME: {
                return player.getName().getString();
            }
            case NICKNAME: {
                String nickname = NicknameService.getNickname(player);
                if (nickname != null && !nickname.trim().isEmpty()) {
                    return nickname;
                }
                return player.getName().getString();
            }
        }
        return ChatFormattingUtils.stripFormattingCodes(player.getDisplayName().getString());
    }

    public static String getRawNameForStyle(ServerPlayer player, NameStyle nameStyle) {
        switch (nameStyle) {
            case USERNAME: {
                return player.getName().getString();
            }
            case NICKNAME: {
                String nickname = NicknameService.getNickname(player);
                if (nickname != null && !nickname.trim().isEmpty()) {
                    return nickname;
                }
                return player.getName().getString();
            }
        }
        return player.getDisplayName().getString();
    }
}

