/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.Verbatim;

public class PermissionService {
    private Object luckPermsApi = null;
    private Boolean luckPermsAvailable = null;

    public PermissionService() {
        Verbatim.LOGGER.info("[Verbatim PermissionService] PermissionService initialized. LuckPerms availability will be checked when first needed.");
    }

    private void ensureLuckPermsChecked() {
        if (this.luckPermsAvailable == null) {
            try {
                Class<?> luckPermsProviderClass = Class.forName("net.luckperms.api.LuckPermsProvider");
                Method getMethod = luckPermsProviderClass.getMethod("get", new Class[0]);
                this.luckPermsApi = getMethod.invoke(null, new Object[0]);
                this.luckPermsAvailable = true;
                Verbatim.LOGGER.info("[Verbatim PermissionService] LuckPerms API found and loaded. Permissions will be handled by LuckPerms.");
            }
            catch (ClassNotFoundException e) {
                this.luckPermsApi = null;
                this.luckPermsAvailable = false;
                Verbatim.LOGGER.warn("[Verbatim PermissionService] LuckPerms classes not found. Permissions will use vanilla OP levels as fallback.");
            }
            catch (Exception e) {
                this.luckPermsApi = null;
                this.luckPermsAvailable = false;
                Verbatim.LOGGER.warn("[Verbatim PermissionService] LuckPerms API not available: {}. Permissions will use vanilla OP levels as fallback.", (Object)e.getMessage());
            }
        }
    }

    public boolean isLuckPermsAvailable() {
        this.ensureLuckPermsChecked();
        return this.luckPermsAvailable;
    }

    public boolean hasPermission(ServerPlayer player, String permissionNode, int opLevelIfLuckPermsAbsent) {
        block14: {
            if (player == null) {
                Verbatim.LOGGER.warn("[Verbatim PermissionService] Attempted to check permission for a null player. Denying.");
                return false;
            }
            if (permissionNode == null || permissionNode.isEmpty()) {
                Verbatim.LOGGER.warn("[Verbatim PermissionService] Attempted to check a null or empty permissionNode for player {}. Denying.", (Object)player.getName().getString());
                return false;
            }
            this.ensureLuckPermsChecked();
            if (this.luckPermsAvailable.booleanValue() && this.luckPermsApi != null) {
                try {
                    Method getUserManagerMethod = this.luckPermsApi.getClass().getMethod("getUserManager", new Class[0]);
                    Object userManager = getUserManagerMethod.invoke(this.luckPermsApi, new Object[0]);
                    Method getUserMethod = userManager.getClass().getMethod("getUser", UUID.class);
                    Object user = getUserMethod.invoke(userManager, player.getUUID());
                    if (user != null) {
                        Method getCachedDataMethod = user.getClass().getMethod("getCachedData", new Class[0]);
                        Object cachedData = getCachedDataMethod.invoke(user, new Object[0]);
                        Method getPermissionDataMethod = cachedData.getClass().getMethod("getPermissionData", new Class[0]);
                        Object permissionData = getPermissionDataMethod.invoke(cachedData, new Object[0]);
                        Method checkPermissionMethod = permissionData.getClass().getMethod("checkPermission", String.class);
                        Object permissionResult = checkPermissionMethod.invoke(permissionData, permissionNode);
                        Method asBooleanMethod = permissionResult.getClass().getMethod("asBoolean", new Class[0]);
                        boolean checkResult = (Boolean)asBooleanMethod.invoke(permissionResult, new Object[0]);
                        Verbatim.LOGGER.debug("[Verbatim PermissionService] LuckPerms check for player '{}', node '{}': {} (UUID: {})", new Object[]{player.getName().getString(), permissionNode, checkResult, player.getUUID()});
                        return checkResult;
                    }
                    Verbatim.LOGGER.warn("[Verbatim PermissionService] LuckPerms available, but user '{}' (UUID: {}) not found by LuckPerms. Attempting to load user...", (Object)player.getName().getString(), (Object)player.getUUID());
                    try {
                        Method loadUserMethod = userManager.getClass().getMethod("loadUser", UUID.class);
                        Object completableFuture = loadUserMethod.invoke(userManager, player.getUUID());
                        Method getMethod = completableFuture.getClass().getMethod("get", new Class[0]);
                        Object loadedUser = getMethod.invoke(completableFuture, new Object[0]);
                        if (loadedUser != null) {
                            Method getCachedDataMethod = loadedUser.getClass().getMethod("getCachedData", new Class[0]);
                            Object cachedData = getCachedDataMethod.invoke(loadedUser, new Object[0]);
                            Method getPermissionDataMethod = cachedData.getClass().getMethod("getPermissionData", new Class[0]);
                            Object permissionData = getPermissionDataMethod.invoke(cachedData, new Object[0]);
                            Method checkPermissionMethod = permissionData.getClass().getMethod("checkPermission", String.class);
                            Object permissionResult = checkPermissionMethod.invoke(permissionData, permissionNode);
                            Method asBooleanMethod = permissionResult.getClass().getMethod("asBoolean", new Class[0]);
                            boolean checkResult = (Boolean)asBooleanMethod.invoke(permissionResult, new Object[0]);
                            Verbatim.LOGGER.info("[Verbatim PermissionService] After loading user '{}', permission check for node '{}': {}", new Object[]{player.getName().getString(), permissionNode, checkResult});
                            return checkResult;
                        }
                        Verbatim.LOGGER.warn("[Verbatim PermissionService] Loaded user '{}' was null. Falling back to OP check for permission '{}'.", (Object)player.getName().getString(), (Object)permissionNode);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof IllegalStateException) {
                            Verbatim.LOGGER.warn("[Verbatim PermissionService] LuckPerms capability not available for player '{}' during user load ({}). This can happen during respawn. Falling back to OP level check.", (Object)player.getName().getString(), (Object)e.getCause().getMessage());
                            break block14;
                        }
                        Verbatim.LOGGER.error("[Verbatim PermissionService] Failed to load user '{}' from LuckPerms via reflection (InvocationTargetException): {}. Cause: {}. Falling back to OP check.", new Object[]{player.getName().getString(), e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : "null"});
                    }
                    catch (Exception e) {
                        Verbatim.LOGGER.error("[Verbatim PermissionService] Failed to load user '{}' from LuckPerms via reflection (General Exception): {}. Falling back to OP check.", (Object)player.getName().getString(), (Object)e.getMessage());
                    }
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof IllegalStateException) {
                        Verbatim.LOGGER.warn("[Verbatim PermissionService] LuckPerms capability not available for player '{}' ({}). This can happen during respawn. Falling back to OP level check.", (Object)player.getName().getString(), (Object)e.getCause().getMessage());
                    } else {
                        Verbatim.LOGGER.error("[Verbatim PermissionService] Error accessing LuckPerms API via reflection (InvocationTargetException for {}): {}. Cause: {}. Falling back to OP check.", new Object[]{player.getName().getString(), e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : "null"});
                    }
                }
                catch (Exception e) {
                    Verbatim.LOGGER.error("[Verbatim PermissionService] Error accessing LuckPerms API via reflection (General Exception for {}): {}. Falling back to OP check.", (Object)player.getName().getString(), (Object)e.getMessage());
                }
            }
        }
        boolean opCheckResult = player.hasPermissions(opLevelIfLuckPermsAbsent);
        Verbatim.LOGGER.info("[Verbatim PermissionService] Vanilla OP check for player '{}', level {}: {} (for permission '{}')", new Object[]{player.getName().getString(), opLevelIfLuckPermsAbsent, opCheckResult, permissionNode});
        return opCheckResult;
    }
}

