/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim.util;

import java.util.ArrayList;
import java.util.List;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.verbatim.Verbatim;

public class PrefixService {
    private LuckPerms luckPermsApi = null;
    private Boolean luckPermsAvailable = null;

    public PrefixService() {
        Verbatim.LOGGER.info("[Verbatim PrefixService] PrefixService initialized. LuckPerms availability will be checked when first needed.");
    }

    private void ensureLuckPermsChecked() {
        if (this.luckPermsAvailable == null) {
            try {
                this.luckPermsApi = LuckPermsProvider.get();
                this.luckPermsAvailable = true;
                Verbatim.LOGGER.info("[Verbatim PrefixService] LuckPerms API found and loaded. Prefixes will be handled by LuckPerms.");
            }
            catch (IllegalStateException e) {
                this.luckPermsApi = null;
                this.luckPermsAvailable = false;
                Verbatim.LOGGER.info("[Verbatim PrefixService] LuckPerms API not found. Prefixes will not be displayed.");
            }
        }
    }

    public boolean isLuckPermsAvailable() {
        this.ensureLuckPermsChecked();
        return this.luckPermsAvailable;
    }

    public String getPlayerPrefix(ServerPlayer player) {
        if (player == null) {
            return "";
        }
        this.ensureLuckPermsChecked();
        if (!this.luckPermsAvailable.booleanValue() || this.luckPermsApi == null) {
            return "";
        }
        try {
            User user = this.luckPermsApi.getUserManager().getUser(player.getUUID());
            if (user != null) {
                CachedMetaData metaData = user.getCachedData().getMetaData();
                String prefix = metaData.getPrefix();
                return prefix != null ? prefix : "";
            }
            try {
                User loadedUser = (User)this.luckPermsApi.getUserManager().loadUser(player.getUUID()).get();
                if (loadedUser != null) {
                    CachedMetaData metaData = loadedUser.getCachedData().getMetaData();
                    String prefix = metaData.getPrefix();
                    return prefix != null ? prefix : "";
                }
            }
            catch (Exception e) {
                Verbatim.LOGGER.debug("[Verbatim PrefixService] Failed to load user '{}' for prefix: {}", (Object)player.getName().getString(), (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.debug("[Verbatim PrefixService] Error getting prefix for player '{}': {}", (Object)player.getName().getString(), (Object)e.getMessage());
        }
        return "";
    }

    public String getPlayerPrimaryGroup(ServerPlayer player) {
        if (player == null) {
            return "";
        }
        this.ensureLuckPermsChecked();
        if (!this.luckPermsAvailable.booleanValue() || this.luckPermsApi == null) {
            return "";
        }
        try {
            User user = this.luckPermsApi.getUserManager().getUser(player.getUUID());
            if (user != null) {
                String primaryGroup = user.getPrimaryGroup();
                return primaryGroup != null ? primaryGroup : "";
            }
            try {
                User loadedUser = (User)this.luckPermsApi.getUserManager().loadUser(player.getUUID()).get();
                if (loadedUser != null) {
                    String primaryGroup = loadedUser.getPrimaryGroup();
                    return primaryGroup != null ? primaryGroup : "";
                }
            }
            catch (Exception e) {
                Verbatim.LOGGER.debug("[Verbatim PrefixService] Failed to load user '{}' for primary group: {}", (Object)player.getName().getString(), (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.debug("[Verbatim PrefixService] Error getting primary group for player '{}': {}", (Object)player.getName().getString(), (Object)e.getMessage());
        }
        return "";
    }

    public List<String> getPlayerGroups(ServerPlayer player) {
        ArrayList<String> groups;
        block8: {
            groups = new ArrayList<String>();
            if (player == null) {
                return groups;
            }
            this.ensureLuckPermsChecked();
            if (!this.luckPermsAvailable.booleanValue() || this.luckPermsApi == null) {
                return groups;
            }
            try {
                User user = this.luckPermsApi.getUserManager().getUser(player.getUUID());
                if (user != null) {
                    user.getNodes().stream().filter(node -> node.getType().name().equals("INHERITANCE")).forEach(node -> {
                        String groupName = node.getKey().replace("group.", "");
                        if (!groupName.isEmpty()) {
                            groups.add(groupName);
                        }
                    });
                    break block8;
                }
                try {
                    User loadedUser = (User)this.luckPermsApi.getUserManager().loadUser(player.getUUID()).get();
                    if (loadedUser != null) {
                        loadedUser.getNodes().stream().filter(node -> node.getType().name().equals("INHERITANCE")).forEach(node -> {
                            String groupName = node.getKey().replace("group.", "");
                            if (!groupName.isEmpty()) {
                                groups.add(groupName);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Verbatim.LOGGER.debug("[Verbatim PrefixService] Failed to load user '{}' for groups: {}", (Object)player.getName().getString(), (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                Verbatim.LOGGER.debug("[Verbatim PrefixService] Error getting groups for player '{}': {}", (Object)player.getName().getString(), (Object)e.getMessage());
            }
        }
        return groups;
    }

    public String getGroupDisplayName(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return "";
        }
        this.ensureLuckPermsChecked();
        if (!this.luckPermsAvailable.booleanValue() || this.luckPermsApi == null) {
            return groupName;
        }
        try {
            Group group = this.luckPermsApi.getGroupManager().getGroup(groupName);
            if (group != null) {
                CachedMetaData metaData = group.getCachedData().getMetaData();
                String displayName = metaData.getMetaValue("displayname");
                return displayName != null ? displayName : groupName;
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.debug("[Verbatim PrefixService] Error getting display name for group '{}': {}", (Object)groupName, (Object)e.getMessage());
        }
        return groupName;
    }

    public String getPrefixTooltip(ServerPlayer player) {
        block10: {
            if (player == null) {
                return null;
            }
            this.ensureLuckPermsChecked();
            if (!this.luckPermsAvailable.booleanValue() || this.luckPermsApi == null) {
                return null;
            }
            try {
                User user = this.luckPermsApi.getUserManager().getUser(player.getUUID());
                if (user != null) {
                    CachedMetaData metaData = user.getCachedData().getMetaData();
                    for (int i = 0; i < 10; ++i) {
                        String tooltipKey = "prefix_tooltip." + i;
                        String tooltip = metaData.getMetaValue(tooltipKey);
                        if (tooltip == null || tooltip.isEmpty()) continue;
                        return tooltip;
                    }
                    break block10;
                }
                try {
                    User loadedUser = (User)this.luckPermsApi.getUserManager().loadUser(player.getUUID()).get();
                    if (loadedUser != null) {
                        CachedMetaData metaData = loadedUser.getCachedData().getMetaData();
                        for (int i = 0; i < 10; ++i) {
                            String tooltipKey = "prefix_tooltip." + i;
                            String tooltip = metaData.getMetaValue(tooltipKey);
                            if (tooltip == null || tooltip.isEmpty()) continue;
                            return tooltip;
                        }
                    }
                }
                catch (Exception e) {
                    Verbatim.LOGGER.debug("[Verbatim PrefixService] Failed to load user '{}' for prefix tooltip: {}", (Object)player.getName().getString(), (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                Verbatim.LOGGER.debug("[Verbatim PrefixService] Error getting prefix tooltip for player '{}': {}", (Object)player.getName().getString(), (Object)e.getMessage());
            }
        }
        return null;
    }
}

