/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.chedsrealismmod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.chedsrealismmod.init.ChedsRealismModModScreens;
import net.mcreator.chedsrealismmod.network.StreetSignGuiButtonMessage;
import net.mcreator.chedsrealismmod.world.inventory.StreetSignGuiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class StreetSignGuiScreen
extends AbstractContainerScreen<StreetSignGuiMenu>
implements ChedsRealismModModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox signCityName;
    private Button button_ok;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"cheds_realism_mod:textures/screens/street_sign_gui.png");

    public StreetSignGuiScreen(StreetSignGuiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 192;
        this.imageHeight = 100;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("signCityName")) {
                this.signCityName.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.signCityName.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.signCityName.isFocused()) {
            return this.signCityName.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String signCityNameValue = this.signCityName.getValue();
        super.resize(minecraft, width, height);
        this.signCityName.setValue(signCityNameValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.cheds_realism_mod.street_sign_gui.label_enter_the_sign_data"), 37, 12, -12829636, false);
    }

    public void init() {
        super.init();
        this.signCityName = new EditBox(this.font, this.leftPos + 35, this.topPos + 34, 118, 18, (Component)Component.translatable((String)"gui.cheds_realism_mod.street_sign_gui.signCityName"));
        this.signCityName.setMaxLength(8192);
        this.signCityName.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((StreetSignGuiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "signCityName", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.signCityName);
        this.button_ok = Button.builder((Component)Component.translatable((String)"gui.cheds_realism_mod.street_sign_gui.button_ok"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new StreetSignGuiButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            StreetSignGuiButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 78, this.topPos + 64, 35, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_ok);
    }
}

