/*
 * Decompiled with CFR 0.152.
 */
package com.pvpranked.enchantments;

import com.pvpranked.EnchantmentSmashDamageInterface;
import com.pvpranked.FaithfulMace;
import com.pvpranked.MaceUtil;
import com.pvpranked.enchantments.WindBurstEnchantment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MaceEnchantmentHelperPort {
    public static void forEachEnchantAfterPostHitMaceForWindBurst(class_1799 stack, class_1309 userAndAttacker, float fallDist) {
        if (userAndAttacker instanceof class_1657 && !stack.method_7960()) {
            class_2499 nbtList = stack.method_7921();
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_7923.field_41176.method_17966(class_1890.method_37427((class_2487)nbtCompound)).ifPresent(enchantment -> {
                    if (enchantment instanceof WindBurstEnchantment) {
                        ((WindBurstEnchantment)((Object)enchantment)).onTargetDamagedCustomLocation(userAndAttacker, class_1890.method_37424((class_2487)nbtCompound), fallDist);
                    }
                });
            }
        }
    }

    public static float damageUtilDotGetDamageLeft(class_1309 armorWearer, float damageAmount, class_1282 damageSource, float armor, float armorToughness) {
        float i;
        class_1937 class_19372;
        class_1799 itemStack;
        float f = 2.0f + armorToughness / 4.0f;
        float g = class_3532.method_15363((float)(armor - damageAmount / f), (float)(armor * 0.2f), (float)20.0f);
        float h = g / 25.0f;
        class_1297 attacker = damageSource.method_5529();
        class_1799 class_17992 = itemStack = attacker instanceof class_1309 ? ((class_1309)attacker).method_6047() : null;
        if (FaithfulMace.superfluousLogging()) {
            FaithfulMace.MOGGER.info("Injecting mace damage alteration. Item that might be a mace: {}, attack victim: {}, attacker: {}", new Object[]{itemStack, armorWearer, damageSource.method_5529()});
        }
        if (itemStack != null && (class_19372 = armorWearer.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            i = class_3532.method_15363((float)MaceEnchantmentHelperPort.getArmorEffectiveness(serverWorld, itemStack, (class_1297)armorWearer, damageSource, h), (float)0.0f, (float)1.0f);
        } else {
            i = h;
        }
        float j = 1.0f - i;
        return damageAmount * j;
    }

    public static float getArmorEffectiveness(class_3218 world, class_1799 stack, class_1297 user, class_1282 damageSource, float baseArmorEffectiveness) {
        try {
            if (FaithfulMace.superfluousLogging()) {
                FaithfulMace.MOGGER.info("Calculating armor effectiveness when attacking item was {}", (Object)stack);
            }
            MutableFloat mutableFloat = new MutableFloat(baseArmorEffectiveness);
            MaceEnchantmentHelperPort.forEachEnchantment(stack, (class_1887 enchantment, int level) -> {
                if (enchantment instanceof EnchantmentSmashDamageInterface) {
                    enchantment.modifyArmorEffectiveness(world, level, stack, user, damageSource, mutableFloat);
                } else if (enchantment != null) {
                    throw new IllegalStateException(MaceUtil.format("Encountered enchantment {} on item {} that doesn't extend EnchantmentSmashDamageInterface while calculating mace armor effectiveness diff, despite the injected interface into superclass {} (Enchantment.class)!", enchantment, stack, class_1887.class));
                }
            });
            if (FaithfulMace.superfluousLogging()) {
                FaithfulMace.MOGGER.info(mutableFloat.floatValue() + " effectiveness diff");
            }
            return mutableFloat.floatValue();
        }
        catch (Exception e) {
            FaithfulMace.MOGGER.error("Exception caught while FaithfulMace was calculating armor effectiveness with stack {} user {} baseValue {} enchantments {}: ", new Object[]{stack, user, Float.valueOf(baseArmorEffectiveness), stack.method_7921(), e});
            throw e;
        }
    }

    public static float getSmashDamagePerFallenBlock(class_3218 world, class_1799 stack, class_1297 target, class_1282 damageSource, float baseSmashDamagePerFallenBlock) {
        try {
            MutableFloat mutableFloat = new MutableFloat(baseSmashDamagePerFallenBlock);
            MaceEnchantmentHelperPort.forEachEnchantment((class_1887 enchantment, int level) -> {
                if (enchantment instanceof EnchantmentSmashDamageInterface) {
                    enchantment.modifySmashDamagePerFallenBlock(world, level, stack, target, damageSource, mutableFloat);
                } else if (enchantment != null) {
                    throw new IllegalStateException(MaceUtil.format("Encountered enchantment {} on item {} that doesn't extend EnchantmentSmashDamageInterface while calculating mace smash damage per block, despite the injected interface into superclass {} (Enchantment.class)!", enchantment, stack, class_1887.class));
                }
            }, stack);
            return mutableFloat.floatValue();
        }
        catch (Exception e) {
            FaithfulMace.MOGGER.error("Exception caught while FaithfulMace was calculating extra base damage with stack {} target {} baseValue {} enchantments {}: ", new Object[]{stack, target, Float.valueOf(baseSmashDamagePerFallenBlock), stack.method_7921(), e});
            throw e;
        }
    }

    private static void forEachEnchantment(class_1799 stack, Consumer consumer) {
        MaceEnchantmentHelperPort.forEachEnchantment(consumer, stack);
    }

    private static void forEachEnchantment(Consumer consumer, class_1799 stack) {
        if (!stack.method_7960()) {
            class_2499 nbtList = stack.method_7921();
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_7923.field_41176.method_17966(class_1890.method_37427((class_2487)nbtCompound)).ifPresent(enchantment -> consumer.accept((class_1887)enchantment, class_1890.method_37424((class_2487)nbtCompound)));
            }
        }
    }

    @FunctionalInterface
    private static interface Consumer {
        public void accept(class_1887 var1, int var2);
    }
}

