/*
 * Decompiled with CFR 0.152.
 */
package com.pvpranked.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.pvpranked.FaithfulMace;
import com.pvpranked.MaceUtil;
import com.pvpranked.enchantments.MaceEnchantmentHelperPort;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class MaceItem
extends class_1792 {
    private static final int ATTACK_DAMAGE_MODIFIER_VALUE = 5;
    private static final float ATTACK_SPEED_MODIFIER_VALUE = -3.4f;
    public static final float MINING_SPEED_MULTIPLIER = 1.5f;
    private static final float HEAVY_SMASH_SOUND_FALL_DISTANCE_THRESHOLD = 5.0f;
    public static final float KNOCKBACK_RANGE = 3.5f;
    private static final float KNOCKBACK_POWER = 0.7f;
    private final float attackDamage;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public MaceItem(class_1792.class_1793 settings) {
        super(settings);
        this.attackDamage = 5.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)-3.4f, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        float fallDist = attacker.field_6017;
        boolean bl6 = false;
        if (target.method_37908() instanceof class_3218) {
            bl6 = this.internalPostHit(stack, target, attacker);
        }
        if (!attacker.method_37908().field_9236 && !stack.method_7960() && target instanceof class_1309 && bl6) {
            this.internalPostDamageEntity(stack, target, attacker);
        }
        MaceEnchantmentHelperPort.forEachEnchantAfterPostHitMaceForWindBurst(stack, attacker, fallDist);
        return true;
    }

    private boolean internalPostHit(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (MaceItem.shouldDealAdditionalDamage(attacker)) {
            class_3222 serverPlayerEntity;
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            attacker.method_18799(attacker.method_18798().method_38499(class_2350.class_2351.field_11052, (double)0.01f));
            if (attacker instanceof class_3222) {
                serverPlayerEntity = (class_3222)attacker;
                serverPlayerEntity.setCurrentExplosionImpactPos(this.getCurrentExplosionImpactPos(serverPlayerEntity));
                serverPlayerEntity.setIgnoreFallDamageFromCurrentExplosion(true);
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2743((class_1297)serverPlayerEntity));
            }
            if (target.method_24828()) {
                if (attacker instanceof class_3222) {
                    serverPlayerEntity = (class_3222)attacker;
                    serverPlayerEntity.setSpawnExtraParticlesOnFall(true);
                }
                class_3414 soundEvent = attacker.field_6017 > 5.0f ? FaithfulMace.ITEM_MACE_SMASH_GROUND_HEAVY_SOUND_EVENT : FaithfulMace.ITEM_MACE_SMASH_GROUND_SOUND_EVENT;
                serverWorld.method_43128((class_1657)null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), soundEvent, attacker.method_5634(), 1.0f, 1.0f);
            } else {
                serverWorld.method_43128((class_1657)null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), FaithfulMace.ITEM_MACE_SMASH_AIR_SOUND_EVENT, attacker.method_5634(), 1.0f, 1.0f);
            }
            MaceItem.knockbackNearbyEntities((class_1937)serverWorld, (class_1297)attacker, (class_1297)target);
        }
        return true;
    }

    private class_243 getCurrentExplosionImpactPos(class_3222 player) {
        return player.ignoreFallDamageFromCurrentExplosion() && player.currentExplosionImpactPos() != null && player.currentExplosionImpactPos().field_1351 <= player.method_19538().field_1351 ? player.currentExplosionImpactPos() : player.method_19538();
    }

    private void internalPostDamageEntity(class_1799 stack, class_1309 target, class_1309 attacker) {
        MaceUtil.itemStackDamage(stack, 1, attacker, class_1304.field_6173);
        if (MaceItem.shouldDealAdditionalDamage(attacker)) {
            attacker.method_38785();
        }
    }

    public float getBonusAttackDamage(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 var5 = damageSource.method_5526();
        if (var5 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)var5;
            if (!MaceItem.shouldDealAdditionalDamage(livingEntity)) {
                return 0.0f;
            }
            float f = 3.0f;
            float g = 8.0f;
            float h = livingEntity.field_6017;
            float i = h <= 3.0f ? 4.0f * h : (h <= 8.0f ? 12.0f + 2.0f * (h - 3.0f) : 22.0f + h - 8.0f);
            class_1937 var10 = livingEntity.method_37908();
            if (var10 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)var10;
                return i + MaceEnchantmentHelperPort.getSmashDamagePerFallenBlock(serverWorld, livingEntity.method_6047(), target, damageSource, 0.0f) * h;
            }
            return i;
        }
        return 0.0f;
    }

    private static void knockbackNearbyEntities(class_1937 world, class_1297 attacker, class_1297 attacked) {
        world.method_20290(2013, attacked.method_23312(), 750);
        world.method_8390(class_1309.class, attacked.method_5829().method_1014(3.5), MaceItem.getKnockbackPredicate(attacker, attacked)).forEach(entity -> {
            class_243 vec3d = entity.method_19538().method_1020(attacked.method_19538());
            double d = MaceItem.getKnockback(attacker, entity, vec3d);
            class_243 vec3d2 = vec3d.method_1029().method_1021(d);
            if (d > 0.0) {
                entity.method_5762(vec3d2.field_1352, (double)0.7f, vec3d2.field_1350);
                if (entity instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity;
                    serverPlayerEntity.field_13987.method_14364((class_2596)new class_2743((class_1297)serverPlayerEntity));
                }
            }
        });
    }

    private static Predicate<class_1309> getKnockbackPredicate(class_1297 attacker, class_1297 attacked) {
        return entity -> {
            class_1531 armorStandEntity;
            class_1321 tameableEntity;
            boolean bl = !entity.method_7325();
            boolean bl2 = entity != attacker && entity != attacked;
            boolean bl3 = !attacker.method_5722((class_1297)entity);
            boolean var10000 = entity instanceof class_1321 && (tameableEntity = (class_1321)entity).method_6181() && attacker.method_5667().equals(tameableEntity.method_6139());
            boolean bl4 = !var10000;
            var10000 = !(entity instanceof class_1531) || !(armorStandEntity = (class_1531)entity).method_6912();
            boolean bl5 = var10000;
            boolean bl6 = attacked.method_5858((class_1297)entity) <= Math.pow(3.5, 2.0);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        };
    }

    private static double getKnockback(class_1297 attacker, class_1309 attacked, class_243 distance) {
        return (3.5 - distance.method_1033()) * (double)0.7f * (double)(attacker.field_6017 > 5.0f ? 2 : 1) * (1.0 - attacked.method_26825(class_5134.field_23718));
    }

    public static boolean shouldDealAdditionalDamage(class_1309 attacker) {
        return attacker.field_6017 > 1.5f && !attacker.method_6128();
    }

    @Nullable
    public class_1282 getDamageSource(class_1309 user) {
        return MaceItem.shouldDealAdditionalDamage(user) ? user.method_48923().method_48796(FaithfulMace.MACE_SMASH, (class_1297)user) : null;
    }
}

