/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.logic;

import com.jahirtrap.walljump.WallJumpClient;
import com.jahirtrap.walljump.init.ModConfig;
import com.jahirtrap.walljump.init.ModEnchantments;
import com.jahirtrap.walljump.init.ServerConfig;
import com.jahirtrap.walljump.network.message.MessageFallDistance;
import com.jahirtrap.walljump.network.message.MessageWallJump;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9304;

@Environment(value=EnvType.CLIENT)
public class WallJumpLogic {
    public static int ticksWallClinged;
    public static int ticksWallSlid;
    public static boolean stopSlid;
    public static int wallJumpCount;
    private static int ticksKeyDown;
    private static double clingX;
    private static double clingZ;
    private static double lastJumpY;
    private static Set<class_2350> walls;
    private static Set<class_2350> staleWalls;

    private static boolean collidesWithBlock(class_1937 level, class_238 box) {
        return !level.method_18026(box);
    }

    public static void doWallJump(class_746 pl) {
        if (!WallJumpLogic.canWallJump(pl)) {
            return;
        }
        if (pl.method_24828() || pl.method_31549().field_7479 || !pl.method_73183().method_8316(pl.method_24515()).method_15769() || pl.method_3144()) {
            ticksWallClinged = 0;
            ticksWallSlid = 0;
            stopSlid = false;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            wallJumpCount = 0;
            return;
        }
        if (stopSlid) {
            return;
        }
        WallJumpLogic.updateWalls(pl);
        int n = ticksKeyDown = WallJumpClient.KEY_WALL_JUMP.method_1434() ? ticksKeyDown + 1 : 0;
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && WallJumpLogic.canWallCling(pl)) {
                if (ModConfig.autoRotation) {
                    pl.method_36456(WallJumpLogic.getClingDirection().method_10153().method_10144());
                    pl.field_5982 = pl.method_36454();
                }
                ticksWallClinged = 1;
                clingX = pl.method_23317();
                clingZ = pl.method_23321();
                WallJumpLogic.playHitSound((class_1297)pl, WallJumpLogic.getWallPos(pl));
                WallJumpLogic.spawnWallParticle((class_1297)pl, WallJumpLogic.getWallPos(pl));
            }
            return;
        }
        if (!WallJumpClient.KEY_WALL_JUMP.method_1434() || pl.method_24828() || !pl.method_73183().method_8316(pl.method_24515()).method_15769() || walls.isEmpty() || pl.method_7344().method_7586() < 1) {
            ticksWallClinged = 0;
            if (!(pl.field_3913.method_3128().field_1342 == 0.0f && pl.field_3913.method_3128().field_1343 == 0.0f || pl.method_24828() || walls.isEmpty())) {
                if (wallJumpCount >= ServerConfig.maxWallJumps) {
                    return;
                }
                pl.method_38785();
                ClientPlayNetworking.send((class_8710)new MessageWallJump(true));
                WallJumpLogic.wallJump(pl, (float)ServerConfig.wallJumpHeight);
                staleWalls = new HashSet<class_2350>(walls);
            }
            return;
        }
        pl.method_5814(clingX, pl.method_23318(), clingZ);
        double motionY = pl.method_18798().field_1351;
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY += 0.2;
            WallJumpLogic.spawnWallParticle((class_1297)pl, WallJumpLogic.getWallPos(pl));
        } else if (ticksWallClinged++ > ServerConfig.wallSlideDelay) {
            if (ticksWallSlid++ > ServerConfig.stopWallSlideDelay) {
                stopSlid = true;
            }
            motionY = -0.1;
            WallJumpLogic.spawnWallParticle((class_1297)pl, WallJumpLogic.getWallPos(pl));
        } else {
            motionY = 0.0;
        }
        if (pl.field_6017 > 2.0) {
            pl.method_38785();
            ClientPlayNetworking.send((class_8710)new MessageFallDistance((float)(motionY * motionY * 8.0)));
        }
        pl.method_18800(0.0, motionY, 0.0);
    }

    private static boolean canWallJump(class_746 pl) {
        if (ServerConfig.useWallJump) {
            return true;
        }
        if (!ServerConfig.enableEnchantments || !ServerConfig.enableWallJump) {
            return false;
        }
        class_1799 stack = pl.method_6118(class_1304.field_6166);
        if (!stack.method_7960()) {
            class_9304 enchantments = class_1890.method_57532((class_1799)stack);
            try {
                class_6880.class_6883 wjHolder = pl.method_73183().method_30349().method_30530(class_7924.field_41265).method_46747(ModEnchantments.WALL_JUMP);
                return enchantments.method_57536((class_6880)wjHolder) > 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean canWallCling(class_746 pl) {
        if (pl.method_6101() || pl.method_18798().field_1351 > 0.1 || pl.method_7344().method_7586() < 1) {
            return false;
        }
        if (WallJumpLogic.collidesWithBlock(pl.method_73183(), pl.method_5829().method_989(0.0, -0.8, 0.0))) {
            return false;
        }
        if (!ServerConfig.onFallWallCling && pl.method_18798().field_1351 < -0.8) {
            return false;
        }
        if (ServerConfig.allowReClinging || pl.method_23318() < lastJumpY - 1.0) {
            return true;
        }
        return !staleWalls.containsAll(walls);
    }

    private static void updateWalls(class_746 pl) {
        class_243 pos = pl.method_73189();
        class_238 box = new class_238(pos.field_1352 - 0.001, pos.field_1351, pos.field_1350 - 0.001, pos.field_1352 + 0.001, pos.field_1351 + (double)pl.method_5751(), pos.field_1350 + 0.001);
        double dist = (double)(pl.method_17681() / 2.0f) + (ticksWallClinged > 0 ? 0.1 : 0.06);
        class_238[] axes = new class_238[]{box.method_1012(0.0, 0.0, dist), box.method_1012(-dist, 0.0, 0.0), box.method_1012(0.0, 0.0, -dist), box.method_1012(dist, 0.0, 0.0)};
        int i = 0;
        walls = new HashSet<class_2350>();
        for (class_238 axis : axes) {
            class_2350 direction = class_2350.method_10139((int)i++);
            if (!WallJumpLogic.collidesWithBlock(pl.method_73183(), axis) || ServerConfig.blockListMode != ModConfig.BlockListMode.DISABLED && !ServerConfig.blockList.isEmpty() && !WallJumpLogic.areBlocksAllowed(WallJumpLogic.getBlockId(pl, pl.method_24515().method_10093(direction)), WallJumpLogic.getBlockId(pl, pl.method_24515().method_10084().method_10093(direction)))) continue;
            walls.add(direction);
            pl.field_5976 = true;
        }
    }

    private static String getBlockId(class_746 pl, class_2338 pos) {
        class_2680 state = pl.method_73183().method_8320(pos);
        return state.method_51367() ? class_7923.field_41175.method_10221((Object)state.method_26204()).toString() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean areBlocksAllowed(String ... blocks) {
        String[] stringArray = blocks;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 >= n) {
                    return false;
                }
                String block = stringArray[n2];
                if (block == null) break block7;
                switch (ServerConfig.blockListMode) {
                    case BLACKLIST: {
                        if (!ServerConfig.blockList.contains(block)) {
                            break;
                        }
                        break block7;
                    }
                    case WHITELIST: {
                        if (!ServerConfig.blockList.contains(block)) break block7;
                    }
                }
                return true;
            }
            ++n2;
        }
    }

    private static class_2350 getClingDirection() {
        return walls.isEmpty() ? class_2350.field_11036 : walls.iterator().next();
    }

    private static class_2338 getWallPos(class_746 player) {
        class_2338 blockPos = player.method_23312().method_10093(WallJumpLogic.getClingDirection());
        return player.method_73183().method_8320(blockPos).method_51367() ? blockPos : blockPos.method_10093(class_2350.field_11036);
    }

    private static void wallJump(class_746 pl, float up) {
        float strafe = Math.signum(pl.field_3913.method_3128().field_1343) * up * up;
        float forward = Math.signum(pl.field_3913.method_3128().field_1342) * up * up;
        float f = (float)(1.0 / Math.sqrt(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = (float)(Math.sin(pl.method_36454() * ((float)Math.PI / 180)) * (double)0.45f);
        float f2 = (float)(Math.cos(pl.method_36454() * ((float)Math.PI / 180)) * (double)0.45f);
        int jumpBoostLevel = 0;
        class_1293 jumpBoostEffect = pl.method_6112(class_1294.field_5913);
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.method_5578() + 1;
        }
        class_243 motion = pl.method_18798();
        pl.method_18800(motion.field_1352 + (double)(strafe * f2 - forward * f1), (double)up + (double)jumpBoostLevel * 0.125, motion.field_1350 + (double)(forward * f2 + strafe * f1));
        lastJumpY = pl.method_23318();
        WallJumpLogic.playBreakSound((class_1297)pl, WallJumpLogic.getWallPos(pl));
        WallJumpLogic.spawnWallParticle((class_1297)pl, WallJumpLogic.getWallPos(pl));
        ++wallJumpCount;
    }

    private static void playHitSound(class_1297 entity, class_2338 blockPos) {
        class_2680 state = entity.method_73183().method_8320(blockPos);
        class_2498 soundtype = state.method_26204().method_9573(state);
        entity.method_5783(soundtype.method_10596(), soundtype.method_10597() * 0.25f, soundtype.method_10599());
    }

    private static void playBreakSound(class_1297 entity, class_2338 blockPos) {
        class_2680 state = entity.method_73183().method_8320(blockPos);
        class_2498 soundtype = state.method_26204().method_9573(state);
        entity.method_5783(soundtype.method_10593(), soundtype.method_10597() * 0.5f, soundtype.method_10599());
    }

    private static void spawnWallParticle(class_1297 entity, class_2338 blockPos) {
        class_2680 state = entity.method_73183().method_8320(blockPos);
        if (state.method_26217() != class_2464.field_11455) {
            class_243 pos = entity.method_73189();
            class_2382 motion = WallJumpLogic.getClingDirection().method_62675();
            entity.method_73183().method_8406((class_2394)new class_2388(class_2398.field_11217, state), pos.field_1352, pos.field_1351, pos.field_1350, (double)motion.method_10263() * -1.0, -1.0, (double)motion.method_10260() * -1.0);
        }
    }

    static {
        stopSlid = false;
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<class_2350>();
        staleWalls = new HashSet<class_2350>();
    }
}

