/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.sound;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingSoundInstance
extends AbstractTickableSoundInstance {
    private final LocalPlayer player;

    public FallingSoundInstance(LocalPlayer player) {
        super(SoundEvents.ELYTRA_FLYING, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    public void tick() {
        float length = (float)this.player.getDeltaMovement().lengthSqr();
        if (this.player.isAlive() && (double)length >= 0.7) {
            this.volume = Mth.clamp((float)((length - 0.7f) / 4.0f), (float)0.0f, (float)1.0f);
            this.pitch = (double)this.volume > 0.8 ? 1.0f + (this.volume - 0.8f) : 1.0f;
        } else {
            this.stop();
        }
    }

    public boolean canStartSilent() {
        return true;
    }
}

