/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump;

import com.jahirtrap.walljump.init.ModConfig;
import com.jahirtrap.walljump.sound.FallingSoundInstance;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="walljump", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WallJumpClient {
    public static FallingSoundInstance FALLING_SOUND;
    public static KeyMapping.Category KEY_CATEGORY_WALL_JUMP;
    public static KeyMapping KEY_WALL_JUMP;

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(KEY_WALL_JUMP);
    }

    public static void playFallingSound(LocalPlayer player) {
        if (ModConfig.playFallingSound && player.fallDistance > 1.5 && !player.isFallFlying() && (FALLING_SOUND == null || FALLING_SOUND.isStopped())) {
            FALLING_SOUND = new FallingSoundInstance(player);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)FALLING_SOUND);
        }
    }

    static {
        KEY_CATEGORY_WALL_JUMP = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"walljump", (String)"wall_jump"));
        KEY_WALL_JUMP = new KeyMapping("key.walljump.walljump", 340, KEY_CATEGORY_WALL_JUMP);
    }
}

