/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.logic;

import com.jahirtrap.walljump.WallJumpClient;
import com.jahirtrap.walljump.init.ModConfig;
import com.jahirtrap.walljump.init.ModEnchantments;
import com.jahirtrap.walljump.init.ServerConfig;
import com.jahirtrap.walljump.network.PacketHandler;
import com.jahirtrap.walljump.network.message.MessageFallDistance;
import com.jahirtrap.walljump.network.message.MessageWallJump;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WallJumpLogic {
    public static int ticksWallClinged;
    public static int ticksWallSlid;
    public static boolean stopSlid;
    public static int wallJumpCount;
    private static int ticksKeyDown;
    private static double clingX;
    private static double clingZ;
    private static double lastJumpY;
    private static Set<Direction> walls;
    private static Set<Direction> staleWalls;

    private static boolean collidesWithBlock(Level level, AABB box) {
        return !level.noCollision(box);
    }

    public static void doWallJump(LocalPlayer pl) {
        if (!WallJumpLogic.canWallJump(pl)) {
            return;
        }
        if (pl.onGround() || pl.getAbilities().flying || !pl.level().getFluidState(pl.blockPosition()).isEmpty() || pl.isHandsBusy()) {
            ticksWallClinged = 0;
            ticksWallSlid = 0;
            stopSlid = false;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            wallJumpCount = 0;
            return;
        }
        if (stopSlid) {
            return;
        }
        WallJumpLogic.updateWalls(pl);
        int n = ticksKeyDown = WallJumpClient.KEY_WALL_JUMP.isDown() ? ticksKeyDown + 1 : 0;
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && WallJumpLogic.canWallCling(pl)) {
                if (ModConfig.autoRotation) {
                    pl.setYRot(WallJumpLogic.getClingDirection().getOpposite().toYRot());
                    pl.yRotO = pl.getYRot();
                }
                ticksWallClinged = 1;
                clingX = pl.getX();
                clingZ = pl.getZ();
                WallJumpLogic.playHitSound((Entity)pl, WallJumpLogic.getWallPos(pl));
                WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
            }
            return;
        }
        if (!WallJumpClient.KEY_WALL_JUMP.isDown() || pl.onGround() || !pl.level().getFluidState(pl.blockPosition()).isEmpty() || walls.isEmpty() || pl.getFoodData().getFoodLevel() < 1) {
            ticksWallClinged = 0;
            if (!(pl.input.getMoveVector().y == 0.0f && pl.input.getMoveVector().x == 0.0f || pl.onGround() || walls.isEmpty())) {
                if (wallJumpCount >= ServerConfig.maxWallJumps) {
                    return;
                }
                pl.resetFallDistance();
                PacketHandler.sendToServer(new MessageWallJump(true));
                WallJumpLogic.wallJump(pl, (float)ServerConfig.wallJumpHeight);
                staleWalls = new HashSet<Direction>(walls);
            }
            return;
        }
        pl.setPos(clingX, pl.getY(), clingZ);
        double motionY = pl.getDeltaMovement().y;
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY += 0.2;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else if (ticksWallClinged++ > ServerConfig.wallSlideDelay) {
            if (ticksWallSlid++ > ServerConfig.stopWallSlideDelay) {
                stopSlid = true;
            }
            motionY = -0.1;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else {
            motionY = 0.0;
        }
        if (pl.fallDistance > 2.0) {
            pl.resetFallDistance();
            PacketHandler.sendToServer(new MessageFallDistance((float)(motionY * motionY * 8.0)));
        }
        pl.setDeltaMovement(0.0, motionY, 0.0);
    }

    private static boolean canWallJump(LocalPlayer pl) {
        if (ServerConfig.useWallJump) {
            return true;
        }
        if (!ServerConfig.enableEnchantments || !ServerConfig.enableWallJump) {
            return false;
        }
        ItemStack stack = pl.getItemBySlot(EquipmentSlot.FEET);
        if (!stack.isEmpty()) {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            try {
                Holder.Reference wjHolder = pl.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModEnchantments.WALL_JUMP);
                return enchantments.getLevel((Holder)wjHolder) > 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean canWallCling(LocalPlayer pl) {
        if (pl.onClimbable() || pl.getDeltaMovement().y > 0.1 || pl.getFoodData().getFoodLevel() < 1) {
            return false;
        }
        if (WallJumpLogic.collidesWithBlock(pl.level(), pl.getBoundingBox().move(0.0, -0.8, 0.0))) {
            return false;
        }
        if (!ServerConfig.onFallWallCling && pl.getDeltaMovement().y < -0.8) {
            return false;
        }
        if (ServerConfig.allowReClinging || pl.getY() < lastJumpY - 1.0) {
            return true;
        }
        return !staleWalls.containsAll(walls);
    }

    private static void updateWalls(LocalPlayer pl) {
        Vec3 pos = pl.position();
        AABB box = new AABB(pos.x - 0.001, pos.y, pos.z - 0.001, pos.x + 0.001, pos.y + (double)pl.getEyeHeight(), pos.z + 0.001);
        double dist = (double)(pl.getBbWidth() / 2.0f) + (ticksWallClinged > 0 ? 0.1 : 0.06);
        AABB[] axes = new AABB[]{box.expandTowards(0.0, 0.0, dist), box.expandTowards(-dist, 0.0, 0.0), box.expandTowards(0.0, 0.0, -dist), box.expandTowards(dist, 0.0, 0.0)};
        int i = 0;
        walls = new HashSet<Direction>();
        for (AABB axis : axes) {
            Direction direction = Direction.from2DDataValue((int)i++);
            if (!WallJumpLogic.collidesWithBlock(pl.level(), axis) || ServerConfig.blockListMode != ModConfig.BlockListMode.DISABLED && !ServerConfig.blockList.isEmpty() && !WallJumpLogic.areBlocksAllowed(WallJumpLogic.getBlockId(pl, pl.blockPosition().relative(direction)), WallJumpLogic.getBlockId(pl, pl.blockPosition().above().relative(direction)))) continue;
            walls.add(direction);
            pl.horizontalCollision = true;
        }
    }

    private static String getBlockId(LocalPlayer pl, BlockPos pos) {
        BlockState state = pl.level().getBlockState(pos);
        return state.isSolid() ? BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean areBlocksAllowed(String ... blocks) {
        String[] stringArray = blocks;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 >= n) {
                    return false;
                }
                String block = stringArray[n2];
                if (block == null) break block7;
                switch (ServerConfig.blockListMode) {
                    case BLACKLIST: {
                        if (!ServerConfig.blockList.contains(block)) {
                            break;
                        }
                        break block7;
                    }
                    case WHITELIST: {
                        if (!ServerConfig.blockList.contains(block)) break block7;
                    }
                }
                return true;
            }
            ++n2;
        }
    }

    private static Direction getClingDirection() {
        return walls.isEmpty() ? Direction.UP : walls.iterator().next();
    }

    private static BlockPos getWallPos(LocalPlayer player) {
        BlockPos blockPos = player.getOnPos().relative(WallJumpLogic.getClingDirection());
        return player.level().getBlockState(blockPos).isSolid() ? blockPos : blockPos.relative(Direction.UP);
    }

    private static void wallJump(LocalPlayer pl, float up) {
        float strafe = Math.signum(pl.input.getMoveVector().x) * up * up;
        float forward = Math.signum(pl.input.getMoveVector().y) * up * up;
        float f = (float)(1.0 / Math.sqrt(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = (float)(Math.sin(pl.getYRot() * ((float)Math.PI / 180)) * (double)0.45f);
        float f2 = (float)(Math.cos(pl.getYRot() * ((float)Math.PI / 180)) * (double)0.45f);
        int jumpBoostLevel = 0;
        MobEffectInstance jumpBoostEffect = pl.getEffect(MobEffects.JUMP_BOOST);
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.getAmplifier() + 1;
        }
        Vec3 motion = pl.getDeltaMovement();
        pl.setDeltaMovement(motion.x + (double)(strafe * f2 - forward * f1), (double)up + (double)jumpBoostLevel * 0.125, motion.z + (double)(forward * f2 + strafe * f1));
        lastJumpY = pl.getY();
        WallJumpLogic.playBreakSound((Entity)pl, WallJumpLogic.getWallPos(pl));
        WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        ++wallJumpCount;
    }

    private static void playHitSound(Entity entity, BlockPos blockPos) {
        BlockState state = entity.level().getBlockState(blockPos);
        SoundType soundtype = state.getBlock().getSoundType(state, (LevelReader)entity.level(), blockPos, entity);
        entity.playSound(soundtype.getHitSound(), soundtype.getVolume() * 0.25f, soundtype.getPitch());
    }

    private static void playBreakSound(Entity entity, BlockPos blockPos) {
        BlockState state = entity.level().getBlockState(blockPos);
        SoundType soundtype = state.getBlock().getSoundType(state, (LevelReader)entity.level(), blockPos, entity);
        entity.playSound(soundtype.getFallSound(), soundtype.getVolume() * 0.5f, soundtype.getPitch());
    }

    private static void spawnWallParticle(Entity entity, BlockPos blockPos) {
        BlockState state = entity.level().getBlockState(blockPos);
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 pos = entity.position();
            Vec3i motion = WallJumpLogic.getClingDirection().getUnitVec3i();
            entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), pos.x, pos.y, pos.z, (double)motion.getX() * -1.0, -1.0, (double)motion.getZ() * -1.0);
        }
    }

    static {
        stopSlid = false;
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<Direction>();
        staleWalls = new HashSet<Direction>();
    }
}

