/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.network.message;

import com.jahirtrap.walljump.init.ServerConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;

public record MessageWallJump(boolean didWallJump) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"walljump", (String)"message_wall_jump");
    public static final CustomPacketPayload.Type<MessageWallJump> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, MessageWallJump> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, MessageWallJump::didWallJump, MessageWallJump::new);

    public static void handle(MessageWallJump message, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer patt0$temp = context.getSender();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = patt0$temp;
                if (message.didWallJump) {
                    player.resetFallDistance();
                    player.causeFoodExhaustion((float)ServerConfig.exhaustionWallJump);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

