/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.server.UtilCommand;
import com.vecoo.extralib.text.UtilText;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.util.PermissionNodes;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.jetbrains.annotations.NotNull;

public class LegendControlCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lc").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEGENDCONTROL_COMMAND))).then(Commands.literal((String)"add").then(Commands.argument((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests(UtilCommand.suggestAmount((Collection)Sets.newHashSet((Object[])new Integer[]{10, 25, 50}))).executes(e -> LegendControlCommand.executeAdd((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 25, 50}).iterator();
            while (iterator.hasNext()) {
                int chance = (Integer)iterator.next();
                builder.suggest(chance);
            }
            return builder.buildFuture();
        }).executes(e -> LegendControlCommand.executeRemove((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests(UtilCommand.suggestAmount((Collection)Sets.newHashSet((Object[])new Integer[]{10, 50, 100}))).executes(e -> LegendControlCommand.executeSet((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.literal((String)"reload").executes(e -> LegendControlCommand.executeReload((CommandSourceStack)e.getSource()))));
    }

    private static int executeAdd(@NotNull CommandSourceStack source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() + chance > 100.0f) {
            source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()));
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.addChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeRemove(@NotNull CommandSourceStack source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() - chance < 0.0f) {
            source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()));
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.removeChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeSet(@NotNull CommandSourceStack source, float chance) {
        if (!LegendControlFactory.ServerProvider.setChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeReload(@NotNull CommandSourceStack source) {
        LegendControl.getInstance().loadConfig();
        LegendControl.getInstance().loadStorage();
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getReload()));
        return 1;
    }
}

