/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.storage;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.storage.ServerStorage;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ServerProvider {
    private final transient String filePath;
    private ServerStorage serverStorage;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public ServerProvider(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
    }

    @NotNull
    public ServerStorage getStorage() {
        if (this.serverStorage == null) {
            this.serverStorage = new ServerStorage(LegendControl.getInstance().getConfig().getBaseChance(), "None");
        }
        return this.serverStorage;
    }

    public void updateServerStorage(@NotNull ServerStorage storage) {
        this.serverStorage = storage;
        this.dirty = true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"ServerStorage.json", (String)UtilGson.newGson().toJson((Object)this.getStorage())).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(3600L).infinite().consume(task -> {
                if (LegendControl.getInstance().getServer().isRunning() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"ServerStorage.json", (String)UtilGson.newGson().toJson((Object)this.getStorage())).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        UtilGson.readFileAsync((String)this.filePath, (String)"ServerStorage.json", el -> {
            this.serverStorage = (ServerStorage)UtilGson.newGson().fromJson(el, ServerStorage.class);
        }).join();
        this.writeInterval();
    }
}

