/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.listener;

import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.events.LegendControlEvent;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.config.ServerConfig;
import com.vecoo.legendcontrol.util.WebhookUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class LegendarySpawnListener {
    public static final List<PixelmonEntity> LEGENDS = new ArrayList<PixelmonEntity>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        ServerPlayer player = (ServerPlayer)event.action.spawnLocation.cause;
        PixelmonEntity pixelmonEntity = (PixelmonEntity)event.action.getOrCreateEntity();
        if (!config.isLegendaryRepeat() && LegendControlFactory.ServerProvider.getLastLegend().equals(pixelmonEntity.getPokemonName())) {
            LegendControlFactory.ServerProvider.addChanceLegend("Pixelmon", config.getStepSpawnChance());
            event.setCanceled(true);
            return;
        }
        if (config.isNotifyPersonalLegendarySpawn()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getSpawnPlayerLegendary().replace("%pokemon%", pixelmonEntity.getSpecies().getName()).replace("%x%", String.valueOf(pixelmonEntity.getBlockX())).replace("%y%", String.valueOf(pixelmonEntity.getBlockY())).replace("%z%", String.valueOf(pixelmonEntity.getBlockZ()))));
        }
        LegendControlFactory.ServerProvider.setChanceLegend("Pixelmon", config.getBaseChance());
        LegendControlFactory.ServerProvider.setLastLegend(pixelmonEntity.getPokemonName());
        LEGENDS.add(pixelmonEntity);
        this.setTimers(pixelmonEntity);
        WebhookUtils.spawnWebhook(pixelmonEntity.getPokemon(), (Holder<Biome>)event.action.spawnLocation.biome);
    }

    private void setTimers(@NotNull PixelmonEntity pixelmonEntity) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        if (config.getLocationTime() > 0) {
            TaskTimer.builder().delay((long)config.getLocationTime() * 20L).consume(task -> {
                LegendControlEvent.Location event;
                if (LEGENDS.contains(pixelmonEntity) && !((LegendControlEvent.Location)NeoForge.EVENT_BUS.post((Event)(event = new LegendControlEvent.Location(pixelmonEntity, pixelmonEntity.getX(), pixelmonEntity.getY(), pixelmonEntity.getZ())))).isCanceled()) {
                    UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getLocation().replace("%pokemon%", pixelmonEntity.getPokemonName()).replace("%x%", String.valueOf(pixelmonEntity.getBlockX())).replace("%y%", String.valueOf(pixelmonEntity.getBlockY())).replace("%z%", String.valueOf(pixelmonEntity.getBlockZ())));
                    WebhookUtils.locationWebhook(pixelmonEntity);
                }
            }).build();
        }
        if (config.getDespawnTime() > 0) {
            TaskTimer.builder().delay((long)config.getDespawnTime() * 20L).consume(task -> {
                if (LEGENDS.contains(pixelmonEntity) && !((LegendControlEvent.ForceDespawn)NeoForge.EVENT_BUS.post((Event)new LegendControlEvent.ForceDespawn(pixelmonEntity))).isCanceled()) {
                    if (pixelmonEntity.battleController != null) {
                        pixelmonEntity.battleController.endBattle();
                    }
                    pixelmonEntity.remove(Entity.RemovalReason.KILLED);
                }
            }).build();
        }
    }
}

