/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.api.yaml.YamlConfigFactory;
import com.vecoo.legendcontrol.command.CheckLegendsCommand;
import com.vecoo.legendcontrol.command.LegendControlCommand;
import com.vecoo.legendcontrol.config.DiscordConfig;
import com.vecoo.legendcontrol.config.LocaleConfig;
import com.vecoo.legendcontrol.config.ServerConfig;
import com.vecoo.legendcontrol.discord.DiscordWebhook;
import com.vecoo.legendcontrol.listener.LegendarySpawnListener;
import com.vecoo.legendcontrol.listener.OtherListener;
import com.vecoo.legendcontrol.listener.ParticleListener;
import com.vecoo.legendcontrol.listener.ResultListener;
import com.vecoo.legendcontrol.storage.ServerProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="legendcontrol")
public class LegendControl {
    public static final String MOD_ID = "legendcontrol";
    private static final Logger LOGGER = LogManager.getLogger();
    private static LegendControl instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private DiscordConfig discord;
    private ServerProvider serverProvider;
    private MinecraftServer server;
    private DiscordWebhook webhook;

    public LegendControl() {
        instance = this;
        this.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ParticleListener());
        MinecraftForge.EVENT_BUS.register((Object)new ResultListener());
        Pixelmon.EVENT_BUS.register((Object)new ResultListener());
        Pixelmon.EVENT_BUS.register((Object)new LegendarySpawnListener());
        Pixelmon.EVENT_BUS.register((Object)new OtherListener());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CheckLegendsCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        LegendControlCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        this.server = event.getServer();
        this.loadStorage();
        PermissionAPI.registerNode((String)"minecraft.command.checkleg", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.checkleg.modify", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
        PermissionAPI.registerNode((String)"minecraft.command.lc", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"");
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.serverProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = (ServerConfig)YamlConfigFactory.getInstance(ServerConfig.class);
            this.locale = (LocaleConfig)YamlConfigFactory.getInstance(LocaleConfig.class);
            this.discord = (DiscordConfig)YamlConfigFactory.getInstance(DiscordConfig.class);
            this.webhook = new DiscordWebhook(this.discord.getWebhookUrl());
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.serverProvider == null) {
                this.serverProvider = new ServerProvider("/%directory%/storage/LegendControl/", this.server);
            }
            this.serverProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    public static LegendControl getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return LegendControl.instance.config;
    }

    public LocaleConfig getLocale() {
        return LegendControl.instance.locale;
    }

    public DiscordConfig getDiscordConfig() {
        return LegendControl.instance.discord;
    }

    public ServerProvider getServerProvider() {
        return LegendControl.instance.serverProvider;
    }

    public MinecraftServer getServer() {
        return LegendControl.instance.server;
    }

    public DiscordWebhook getWebhook() {
        return LegendControl.instance.webhook;
    }
}

