/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.command;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.text.UtilText;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;

public class LegendControlCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lc").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.lc"))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 25, 50}).iterator();
            while (iterator.hasNext()) {
                int chance = (Integer)iterator.next();
                builder.suggest(chance);
            }
            return builder.buildFuture();
        }).executes(e -> LegendControlCommand.executeAdd((CommandSource)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 25, 50}).iterator();
            while (iterator.hasNext()) {
                int chance = (Integer)iterator.next();
                builder.suggest(chance);
            }
            return builder.buildFuture();
        }).executes(e -> LegendControlCommand.executeRemove((CommandSource)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"chance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).suggests((s, builder) -> {
            Iterator iterator = Sets.newHashSet((Object[])new Integer[]{10, 50, 100}).iterator();
            while (iterator.hasNext()) {
                int chance = (Integer)iterator.next();
                builder.suggest(chance);
            }
            return builder.buildFuture();
        }).executes(e -> LegendControlCommand.executeSet((CommandSource)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"chance")))))).then(Commands.func_197057_a((String)"reload").executes(e -> LegendControlCommand.executeReload((CommandSource)e.getSource()))));
    }

    private static int executeAdd(@Nonnull CommandSource source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() + chance > 100.0f) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()), false);
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.addChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))), false);
        return 1;
    }

    private static int executeRemove(@Nonnull CommandSource source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() - chance < 0.0f) {
            source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()), false);
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.removeChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))), false);
        return 1;
    }

    private static int executeSet(@Nonnull CommandSource source, float chance) {
        if (!LegendControlFactory.ServerProvider.setChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))), false);
        return 1;
    }

    private static int executeReload(@Nonnull CommandSource source) {
        LegendControl.getInstance().loadConfig();
        LegendControl.getInstance().loadStorage();
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getReload()), false);
        return 1;
    }
}

