/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.listener;

import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.events.LegendControlEvent;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.config.ServerConfig;
import com.vecoo.legendcontrol.util.WebhookUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LegendarySpawnListener {
    public static final List<PixelmonEntity> LEGENDS = new ArrayList<PixelmonEntity>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        ServerPlayerEntity player = (ServerPlayerEntity)event.action.spawnLocation.cause;
        PixelmonEntity pixelmonEntity = (PixelmonEntity)event.action.getOrCreateEntity();
        if (!config.isLegendaryRepeat() && LegendControlFactory.ServerProvider.getLastLegend().equals(pixelmonEntity.getPokemonName())) {
            LegendControlFactory.ServerProvider.addChanceLegend("Pixelmon", config.getStepSpawnChance());
            event.setCanceled(true);
            return;
        }
        if (config.isNotifyPersonalLegendarySpawn()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getSpawnPlayerLegendary().replace("%pokemon%", pixelmonEntity.getSpecies().getName()).replace("%x%", String.valueOf(pixelmonEntity.func_226277_ct_())).replace("%y%", String.valueOf(pixelmonEntity.func_226278_cu_())).replace("%z%", String.valueOf(pixelmonEntity.func_226281_cx_()))), Util.field_240973_b_);
        }
        LegendControlFactory.ServerProvider.setChanceLegend("Pixelmon", config.getBaseChance());
        LegendControlFactory.ServerProvider.setLastLegend(pixelmonEntity.getPokemonName());
        LEGENDS.add(pixelmonEntity);
        this.setTimers(pixelmonEntity);
        WebhookUtils.spawnWebhook(pixelmonEntity.getPokemon(), event.action.spawnLocation.biome);
    }

    private void setTimers(@Nonnull PixelmonEntity pixelmonEntity) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        if (config.getLocationTime() > 0) {
            TaskTimer.builder().delay((long)config.getLocationTime() * 20L).consume(task -> {
                LegendControlEvent.Location event;
                if (LEGENDS.contains(pixelmonEntity) && !MinecraftForge.EVENT_BUS.post((Event)(event = new LegendControlEvent.Location(pixelmonEntity, pixelmonEntity.func_226277_ct_(), pixelmonEntity.func_226278_cu_(), pixelmonEntity.func_226281_cx_())))) {
                    UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getLocation().replace("%pokemon%", pixelmonEntity.getPokemonName()).replace("%x%", String.valueOf(pixelmonEntity.func_226277_ct_())).replace("%y%", String.valueOf(pixelmonEntity.func_226278_cu_())).replace("%z%", String.valueOf(pixelmonEntity.func_226281_cx_())));
                    WebhookUtils.locationWebhook(pixelmonEntity);
                }
            }).build();
        }
        if (config.getDespawnTime() > 0) {
            TaskTimer.builder().delay((long)config.getDespawnTime() * 20L).consume(task -> {
                if (LEGENDS.contains(pixelmonEntity) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlEvent.ForceDespawn(pixelmonEntity))) {
                    if (pixelmonEntity.battleController != null) {
                        pixelmonEntity.battleController.endBattle();
                    }
                    pixelmonEntity.func_70106_y();
                }
            }).build();
        }
    }
}

