/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.listener;

import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.events.LegendControlEvent;
import com.vecoo.legendcontrol.listener.LegendarySpawnListener;
import com.vecoo.legendcontrol.util.WebhookUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResultListener {
    public static Set<UUID> SUB_LEGENDS = new HashSet<UUID>();

    @SubscribeEvent
    public void onBeatWild(BeatWildPixelmonEvent event) {
        PixelmonEntity pixelmonEntity = event.wpp.getFaintedPokemon().entity;
        if (LegendarySpawnListener.LEGENDS.remove(pixelmonEntity) && LegendControl.getInstance().getConfig().isNotifyLegendaryDefeat()) {
            String playerName = event.player.func_200200_C_().getString();
            UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getNotifyDefeat().replace("%player%", playerName).replace("%pokemon%", pixelmonEntity.getPokemonName()));
            WebhookUtils.defeatWebhook(pixelmonEntity.getPokemon(), playerName);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onStartCapture(CaptureEvent.StartCapture event) {
        PixelmonEntity pixelmonEntity = event.getPokemon();
        if (LegendarySpawnListener.LEGENDS.remove(pixelmonEntity)) {
            SUB_LEGENDS.add(pixelmonEntity.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onFailureCapture(CaptureEvent.FailedCapture event) {
        PixelmonEntity pixelmonEntity = event.getPokemon();
        if (SUB_LEGENDS.remove(pixelmonEntity.func_110124_au())) {
            LegendarySpawnListener.LEGENDS.add(pixelmonEntity);
        }
    }

    @SubscribeEvent
    public void onCapture(CaptureEvent.SuccessfulCapture event) {
        PixelmonEntity pixelmonEntity = event.getPokemon();
        if (SUB_LEGENDS.remove(pixelmonEntity.func_110124_au()) && LegendControl.getInstance().getConfig().isNotifyLegendaryCatch()) {
            String playerName = event.getPlayer().func_200200_C_().getString();
            UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getNotifyCatch().replace("%player%", playerName).replace("%pokemon%", pixelmonEntity.getPokemonName()));
            WebhookUtils.captureWebhook(pixelmonEntity.getPokemon(), playerName);
        }
    }

    @SubscribeEvent
    public void onDespawn(EntityLeaveWorldEvent event) {
        PixelmonEntity pixelmonEntity;
        if (!event.getWorld().func_201670_d() && event.getEntity() instanceof PixelmonEntity && LegendarySpawnListener.LEGENDS.remove(pixelmonEntity = (PixelmonEntity)event.getEntity()) && LegendControl.getInstance().getConfig().isNotifyLegendaryDespawn()) {
            MinecraftForge.EVENT_BUS.post((Event)new LegendControlEvent.ChunkDespawn(pixelmonEntity));
            UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getNotifyDespawn().replace("%pokemon%", pixelmonEntity.getPokemonName()));
            WebhookUtils.despawnWebhook(pixelmonEntity.getPokemon());
        }
    }
}

