/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class MixinsCoreMod
implements IFMLLoadingPlugin {
    private static final String[] ALLOWED_TYPES = new String[]{"jar", "zip"};
    private final List<Tuple<String, String>> coremods = Lists.newArrayList();
    private final List<Tuple<String, String>> loadedCoremods = Lists.newArrayList();

    private void addToCoremodList(String mod, String mixin) {
        if (mod == null || mod.trim().isEmpty() || mixin == null || mixin.trim().isEmpty()) {
            this.log("Loaded a null mod or mixins (mod=" + mod + ", mixin=" + mixin + ") this is not valid and will be dumped!");
        } else {
            this.log("Added Optional Preloader for \"" + mod + "\" using \"" + mixin + "\"");
            this.coremods.add(new Tuple<String, String>(mod, mixin));
        }
    }

    private void loadCoremod(File coremod, Tuple<String, String> target) {
        try {
            if (!CoreModManager.getReparseableCoremods().contains(coremod.getName())) {
                ((LaunchClassLoader)this.getClass().getClassLoader()).addURL(coremod.toURI().toURL());
                CoreModManager.getReparseableCoremods().add(coremod.getName());
                this.log("Preloaded mod \"" + coremod.getName() + "\" containing \"" + target.getFirst() + "\"");
            } else {
                this.log("Skipped Preloading already loaded coremod \"" + coremod.getName() + "\" with \"" + target.getSecond() + "\"");
            }
        }
        catch (Throwable t) {
            this.log("Failed to  load a coremod! Caught " + t.getClass().getSimpleName() + "! caused by " + (target == null ? "target was null" : target.getFirst() + " - " + target.getSecond()), t);
        }
    }

    private void loadCoremodList() {
        this.loadFolder();
        this.initializeMixins();
    }

    private void initializeMixins() {
        try {
            MixinBootstrap.init();
            for (Tuple<String, String> tuple : new ArrayList<Tuple<String, String>>(this.loadedCoremods)) {
                try {
                    this.log("Loading Coremod mixins \"" + tuple.getSecond() + "\"");
                    Mixins.addConfiguration((String)tuple.getSecond());
                }
                catch (Throwable t) {
                    this.log("Caught Exception trying to preload mod configurations for \"" + (tuple != null ? tuple.getSecond() : "null entry") + "\"", t);
                }
            }
        }
        catch (Throwable t) {
            this.log("Caught Exception trying to preload mod configurations", t);
        }
    }

    private void loadFolder() {
        try {
            File modsFolder = new File(System.getProperty("user.dir"), "mods");
            if (!modsFolder.exists()) {
                this.log("The \"mods\" folder couldn't be found skipping this loader! Folder: " + modsFolder.toString());
                return;
            }
            Collection jars = FileUtils.listFiles((File)modsFolder, (String[])ALLOWED_TYPES, (boolean)false);
            for (File jar : jars) {
                ZipEntry entry;
                ZipInputStream zip = new ZipInputStream(Files.newInputStream(jar.toPath(), new OpenOption[0]));
                while ((entry = zip.getNextEntry()) != null) {
                    zip.closeEntry();
                    String name = entry.getName();
                    for (Tuple<String, String> tuple : new ArrayList<Tuple<String, String>>(this.coremods)) {
                        if (!name.equals(tuple.getFirst())) continue;
                        this.loadCoremod(jar, tuple);
                        this.loadedCoremods.add(tuple);
                        this.coremods.remove(tuple);
                    }
                }
                zip.close();
            }
        }
        catch (Throwable t) {
            this.log("Caught Exception trying to load \"mods\" for coremods! This will likely be fatal", t);
        }
    }

    public MixinsCoreMod() {
        this.addToCoremodList("com/pixelmonmod/pixelmon/Pixelmon.class", "mixins.legendcontrol.json");
        this.loadCoremodList();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable e) {
        FMLLog.log.info("[INFO] [Mixins] > " + message);
        if (e != null) {
            for (String s : MixinsCoreMod.getException(e)) {
                FMLLog.log.info("[INFO] [Mixins] > " + s);
            }
        }
    }

    private static List<String> getException(Throwable e) {
        ArrayList exception = Lists.newArrayList((Object[])new String[]{e.getClass().getSimpleName() + ": " + e.getMessage()});
        for (StackTraceElement element : e.getStackTrace()) {
            exception.add(element.toString());
        }
        return exception;
    }

    public static class Tuple<X, Y> {
        private final X x;
        private final Y y;

        public final X getFirst() {
            return this.x;
        }

        public final Y getSecond() {
            return this.y;
        }

        public Tuple(X x, Y y) {
            this.x = x;
            this.y = y;
        }
    }
}

