/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.command;

import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.text.UtilText;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class LegendControlCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "lc";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/lc";
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return sender.func_70003_b(4, "gamemode");
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return LegendControlCommand.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "set", "reload"});
        }
        if (args.length == 2 && !args[0].equals("reload")) {
            return LegendControlCommand.func_71530_a((String[])args, (String[])new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100"});
        }
        return Collections.emptyList();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        try {
            switch (args[0]) {
                case "add": {
                    LegendControlCommand.executeAdd(sender, Float.parseFloat(args[1]));
                    break;
                }
                case "remove": {
                    if (args[1].matches("\\d+")) {
                        LegendControlCommand.executeRemove(sender, Float.parseFloat(args[1]));
                        break;
                    }
                }
                case "set": {
                    if (args[1].matches("\\d+")) {
                        LegendControlCommand.executeSet(sender, Float.parseFloat(args[1]));
                        break;
                    }
                }
                case "reload": {
                    if (!sender.func_70003_b(4, "gamemode")) break;
                    LegendControlCommand.executeReload(sender);
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)UtilChat.formatMessage((String)"/lc"));
        }
    }

    private static int executeAdd(@Nonnull ICommandSender source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() + chance > 100.0f) {
            source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()));
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.addChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeRemove(@Nonnull ICommandSender source, float chance) {
        if (LegendControlFactory.ServerProvider.getChanceLegend() - chance < 0.0f) {
            source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getErrorChance()));
            return 0;
        }
        if (!LegendControlFactory.ServerProvider.removeChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeSet(@Nonnull ICommandSender source, float chance) {
        if (!LegendControlFactory.ServerProvider.setChanceLegend("PlayerAndConsole", chance)) {
            return 0;
        }
        source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getChangeChanceLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend()))));
        return 1;
    }

    private static int executeReload(@Nonnull ICommandSender source) {
        LegendControl.getInstance().loadConfig();
        LegendControl.getInstance().loadStorage();
        source.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getReload()));
        return 1;
    }
}

