/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.listener;

import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.events.LegendControlEvent;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.config.ServerConfig;
import com.vecoo.legendcontrol.util.WebhookUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LegendarySpawnListener {
    public static final List<EntityPixelmon> LEGENDS = new ArrayList<EntityPixelmon>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        EntityPlayerMP player = (EntityPlayerMP)event.action.spawnLocation.cause;
        EntityPixelmon entityPixelmon = (EntityPixelmon)event.action.getOrCreateEntity();
        if (!config.isLegendaryRepeat() && LegendControlFactory.ServerProvider.getLastLegend().equals(entityPixelmon.getPokemonName())) {
            LegendControlFactory.ServerProvider.addChanceLegend("Pixelmon", config.getStepSpawnChance());
            event.setCanceled(true);
            return;
        }
        if (config.isNotifyPersonalLegendarySpawn() && !player.func_193105_t()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getSpawnPlayerLegendary().replace("%pokemon%", entityPixelmon.getSpecies().getPokemonName()).replace("%x%", String.valueOf((int)entityPixelmon.field_70165_t)).replace("%y%", String.valueOf((int)entityPixelmon.field_70163_u)).replace("%z%", String.valueOf((int)entityPixelmon.field_70161_v))));
            LegendControlFactory.ServerProvider.setChanceLegend("Pixelmon", config.getBaseChance());
            LegendControlFactory.ServerProvider.setLastLegend(entityPixelmon.getPokemonName());
            LEGENDS.add(entityPixelmon);
            this.setTimers(entityPixelmon);
            WebhookUtils.spawnWebhook(entityPixelmon.getPokemonData(), event.action.spawnLocation.biome);
        }
    }

    private void setTimers(EntityPixelmon entityPixelmon) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        if (config.getLocationTime() > 0) {
            TaskTimer.builder().delay((long)config.getLocationTime() * 20L).consume(task -> {
                LegendControlEvent.Location event;
                if (LEGENDS.contains(entityPixelmon) && !MinecraftForge.EVENT_BUS.post((Event)(event = new LegendControlEvent.Location(entityPixelmon, entityPixelmon.field_70165_t, entityPixelmon.field_70163_u, entityPixelmon.field_70161_v)))) {
                    UtilChat.broadcast((String)LegendControl.getInstance().getLocale().getLocation().replace("%pokemon%", entityPixelmon.getSpecies().getPokemonName()).replace("%x%", String.valueOf((int)event.getX())).replace("%y%", String.valueOf((int)event.getY())).replace("%z%", String.valueOf((int)event.getZ())));
                    WebhookUtils.locationWebhook(entityPixelmon);
                }
            }).build();
        }
        if (config.getDespawnTime() > 0) {
            TaskTimer.builder().delay((long)config.getDespawnTime() * 20L).consume(task -> {
                if (LEGENDS.contains(entityPixelmon) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlEvent.ForceDespawn(entityPixelmon))) {
                    if (entityPixelmon.battleController != null) {
                        entityPixelmon.battleController.endBattle();
                    }
                    entityPixelmon.func_70106_y();
                }
            }).build();
        }
    }
}

