/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.mixin;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.config.ServerConfig;
import com.vecoo.legendcontrol.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LegendarySpawner.class}, remap=false)
public abstract class LegendarySpawnerMixin
extends TickingSpawner {
    @Shadow
    public List<SpawnAction<?>> possibleSpawns;
    @Shadow
    public boolean firesChooseEvent;
    @Shadow
    public int minDistFromCentre;
    @Shadow
    public int maxDistFromCentre;
    @Shadow
    public int horizontalSliceRadius;
    @Shadow
    public int verticalSliceRadius;

    public LegendarySpawnerMixin(String name) {
        super(name);
    }

    @Shadow
    public void forcefullySpawn(EntityPlayerMP onlyFocus) {
        throw new AssertionError();
    }

    @Overwrite
    public List<SpawnAction<? extends Entity>> getSpawns(int pass) {
        float chance;
        if (pass != 0) {
            return this.possibleSpawns != null && !this.possibleSpawns.isEmpty() ? this.possibleSpawns : null;
        }
        this.possibleSpawns = null;
        int numPlayers = LegendControl.getInstance().getServer().func_184103_al().func_72352_l();
        int baseSpawnTicks = this.firesChooseEvent ? PixelmonConfig.legendarySpawnTicks : PixelmonConfig.bossSpawnTicks;
        this.spawnFrequency = 1200.0f / (RandomHelper.getRandomNumberBetween((float)0.6f, (float)1.4f) * (float)baseSpawnTicks / (1.0f + (float)(numPlayers - 1) * PixelmonConfig.spawnTicksPlayerMultiplier));
        if (this.firesChooseEvent) {
            Utils.TIME_DO_LEGEND = RandomHelper.getRandomNumberBetween((int)LegendControl.getInstance().getConfig().getRandomTimeSpawnMin(), (int)LegendControl.getInstance().getConfig().getRandomTimeSpawnMax());
        }
        float f = chance = this.firesChooseEvent ? LegendControlFactory.ServerProvider.getChanceLegend() / 100.0f : PixelmonConfig.bossSpawnChance;
        if (!RandomHelper.getRandomChance((float)chance)) {
            if (this.firesChooseEvent && numPlayers > 0) {
                LegendControlFactory.ServerProvider.addChanceLegend("Pixelmon", LegendControl.getInstance().getConfig().getStepSpawnChance());
            }
            return null;
        }
        if (numPlayers > 0) {
            this.forcefullySpawn(null);
        }
        return null;
    }

    @Inject(method={"forcefullySpawn"}, at={@At(value="INVOKE", target="Ljava/util/ArrayList;remove(I)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void forcefullySpawn(EntityPlayerMP onlyFocus, CallbackInfo ci, ArrayList<ArrayList<EntityPlayerMP>> clusters, ArrayList<EntityPlayerMP> players, ArrayList<EntityPlayerMP> cluster) {
        ServerConfig config = LegendControl.getInstance().getConfig();
        players.removeIf(player -> config.isBlacklistDimensions() && config.getBlacklistDimensionList().contains(player.func_130014_f_().field_73011_w.getDimension()) || config.isBlacklistPlayers() && config.getBlacklistPlayersList().contains(player.func_70005_c_()));
        if (players.isEmpty()) {
            ci.cancel();
        }
    }

    @Overwrite
    public List<SpawnAction<?>> doLegendarySpawn(EntityPlayerMP target) {
        BlockCollection collection = this.getTrackedBlockCollection((Entity)target, 0.0f, 0.0f, this.horizontalSliceRadius, this.verticalSliceRadius, this.minDistFromCentre, this.maxDistFromCentre);
        ArrayList spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations(collection);
        Collections.shuffle(spawnLocations);
        List possibleSpawns = this.selectionAlgorithm.calculateSpawnActions((AbstractSpawner)this, this.spawnSets, (List)spawnLocations);
        if (possibleSpawns != null && !possibleSpawns.isEmpty()) {
            possibleSpawns.forEach(SpawnAction::applyLocationMutations);
            return possibleSpawns;
        }
        LegendControlFactory.ServerProvider.addChanceLegend("Pixelmon", LegendControl.getInstance().getConfig().getStepSpawnChance());
        return null;
    }
}

