/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.storage;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.storage.ServerStorage;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;

public class ServerProvider {
    private final transient String filePath;
    private ServerStorage serverStorage;
    private transient boolean intervalStarted = false;
    private volatile transient boolean dirty = false;

    public ServerProvider(@Nonnull String filePath, @Nonnull MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
    }

    @Nonnull
    public ServerStorage getStorage() {
        if (this.serverStorage == null) {
            this.serverStorage = new ServerStorage(LegendControl.getInstance().getConfig().getBaseChance(), "None");
        }
        return this.serverStorage;
    }

    public void updateServerStorage(@Nonnull ServerStorage storage) {
        this.serverStorage = storage;
        this.dirty = true;
    }

    public void write() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"ServerStorage.json", (String)UtilGson.newGson().toJson((Object)this.getStorage())).join();
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(3600L).infinite().consume(task -> {
                if (LegendControl.getInstance().getServer().func_71278_l() && this.dirty) {
                    UtilGson.writeFileAsync((String)this.filePath, (String)"ServerStorage.json", (String)UtilGson.newGson().toJson((Object)this.getStorage())).thenRun(() -> {
                        this.dirty = false;
                    });
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        UtilGson.readFileAsync((String)this.filePath, (String)"ServerStorage.json", el -> {
            this.serverStorage = (ServerStorage)UtilGson.newGson().fromJson(el, ServerStorage.class);
        }).join();
        this.writeInterval();
    }
}

