/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.text.UtilText;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.util.PermissionNodes;
import com.vecoo.legendcontrol.util.Utils;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.jetbrains.annotations.NotNull;

public class CheckLegendsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"checkleg").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.CHECKLEGENDARY_COMMAND))).executes(e -> CheckLegendsCommand.execute((CommandSourceStack)e.getSource())));
    }

    private static int execute(@NotNull CommandSourceStack source) {
        int seconds = (int)((PixelmonSpawning.legendarySpawner.nextSpawnTime - System.currentTimeMillis()) / 1000L + (long)Utils.TIME_DO_LEGEND);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        if (seconds < 60) {
            CheckLegendsCommand.sendMessage(source, seconds, LegendControl.getInstance().getLocale().getSeconds());
        } else if (minutes < 60) {
            CheckLegendsCommand.sendMessage(source, minutes, LegendControl.getInstance().getLocale().getMinutes());
        } else {
            CheckLegendsCommand.sendMessage(source, hours, LegendControl.getInstance().getLocale().getHours());
        }
        return 1;
    }

    private static void sendMessage(@NotNull CommandSourceStack source, int time, @NotNull String timeUnit) {
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getCheckLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend())).replace("%time%", time + timeUnit)));
        if (UtilPermission.hasPermission((CommandSourceStack)source, PermissionNodes.CHECKLEGENDARY_MODIFY_COMMAND)) {
            PixelmonSpawning.legendarySpawner.checkSpawns.checkSpawns((AbstractSpawner)PixelmonSpawning.legendarySpawner, source, new ArrayList());
        }
    }
}

