/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.text.UtilText;
import com.vecoo.legendcontrol.LegendControl;
import com.vecoo.legendcontrol.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;

public class CheckLegendsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"checkleg").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.checkleg"))).executes(e -> CheckLegendsCommand.execute((CommandSource)e.getSource())));
    }

    private static int execute(@Nonnull CommandSource source) {
        int seconds = (int)((PixelmonSpawning.legendarySpawner.nextSpawnTime - System.currentTimeMillis()) / 1000L + (long)Utils.TIME_DO_LEGEND);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        if (seconds < 60) {
            CheckLegendsCommand.sendMessage(source, seconds, LegendControl.getInstance().getLocale().getSeconds());
        } else if (minutes < 60) {
            CheckLegendsCommand.sendMessage(source, minutes, LegendControl.getInstance().getLocale().getMinutes());
        } else {
            CheckLegendsCommand.sendMessage(source, hours, LegendControl.getInstance().getLocale().getHours());
        }
        return 1;
    }

    private static void sendMessage(@Nonnull CommandSource source, int time, @Nonnull String timeUnit) {
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControl.getInstance().getLocale().getCheckLegendary().replace("%chance%", UtilText.getFormattedFloat((float)LegendControlFactory.ServerProvider.getChanceLegend())).replace("%time%", time + timeUnit)), false);
        if (UtilPermission.hasPermission((CommandSource)source, (String)"minecraft.command.checkleg.modify")) {
            PixelmonSpawning.legendarySpawner.checkSpawns.checkSpawns((AbstractSpawner)PixelmonSpawning.legendarySpawner, source, new ArrayList());
        }
    }
}

