#version 120

attribute vec4 mc_Entity;

uniform mat4 gbufferModelView;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse;
uniform vec3 cameraPosition;

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 glcolor;
varying vec3 normal;
varying vec3 worldPos;
varying vec3 viewPos;
varying float blockId;

void main() {
    // Pass texture coordinates
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
    
    // Calculate normal
    normal = normalize(gl_NormalMatrix * gl_Normal);
    
    // Calculate world and view positions
    vec4 position = gl_Vertex;
    viewPos = (gbufferModelView * position).xyz;
    worldPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz + cameraPosition;
    
    // Pass block ID
    blockId = mc_Entity.x;
    
    // Calculate final position
    gl_Position = gl_ProjectionMatrix * gbufferModelView * position;
}