#version 120

uniform mat4 gbufferModelView;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse;

varying vec3 viewDir;
varying vec4 glcolor;

void main() {
    glcolor = gl_Color;
    
    vec4 position = gl_Vertex;
    vec4 viewPos = gbufferModelView * position;
    
    // Calculate view direction for sky
    viewDir = (gbufferModelViewInverse * viewPos).xyz;
    
    gl_Position = gl_ProjectionMatrix * viewPos;
}