/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.armor.render;

import net.kenddie.fantasyarmor.client.armor.render.FARenderUtils;
import net.kenddie.fantasyarmor.config.FAConfigs;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class FAArmorRenderer<T extends FAArmorItem>
extends GeoArmorRenderer<T> {
    protected GeoBone cape = null;
    protected GeoBone frontCape = null;
    protected GeoBone leftLegCloth = null;
    protected GeoBone rightLegCloth = null;
    protected GeoBone braid = null;

    public FAArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    @Nullable
    public GeoBone getCapeBone(GeoModel<T> model) {
        return model.getBone("armorCape").orElse(null);
    }

    @Nullable
    public GeoBone getFrontCapeBone(GeoModel<T> model) {
        return model.getBone("armorFrontCape").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegClothBone(GeoModel<T> model) {
        return model.getBone("armorLeftLegCloth").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegClothBone(GeoModel<T> model) {
        return model.getBone("armorRightLegCloth").orElse(null);
    }

    @Nullable
    public GeoBone getBraidBone(GeoModel<T> model) {
        return model.getBone("armorBraid").orElse(null);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        super.grabRelevantBones(bakedModel);
        GeoModel model = this.getGeoModel();
        this.cape = this.getCapeBone(model);
        this.frontCape = this.getFrontCapeBone(model);
        this.leftLegCloth = this.getLeftLegClothBone(model);
        this.rightLegCloth = this.getRightLegClothBone(model);
        this.braid = this.getBraidBone(model);
    }

    protected void applyBoneVisibilityBySlot(class_1304 currentSlot) {
        super.applyBoneVisibilityBySlot(currentSlot);
        switch (currentSlot) {
            case field_6169: {
                this.setBoneVisible(this.braid, true);
                this.setBoneVisible(this.cape, false);
                this.setBoneVisible(this.frontCape, false);
                this.setBoneVisible(this.leftLegCloth, false);
                this.setBoneVisible(this.rightLegCloth, false);
                break;
            }
            case field_6174: {
                this.setBoneVisible(this.cape, FAConfigs.getMainConfig().showCapes);
                this.setBoneVisible(this.frontCape, true);
                this.setBoneVisible(this.leftLegCloth, true);
                this.setBoneVisible(this.rightLegCloth, true);
                this.setBoneVisible(this.braid, false);
                break;
            }
            case field_6172: 
            case field_6166: {
                this.setBoneVisible(this.braid, false);
                this.setBoneVisible(this.cape, false);
                this.setBoneVisible(this.frontCape, false);
                this.setBoneVisible(this.leftLegCloth, false);
                this.setBoneVisible(this.rightLegCloth, false);
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(class_1304 currentSlot, class_630 currentPart, class_572<?> model) {
        super.applyBoneVisibilityByPart(currentSlot, currentPart, model);
        if (currentPart == model.field_3391) {
            if (this.cape != null) {
                this.cape.setHidden(FAConfigs.getMainConfig().showCapes);
            }
            if (this.frontCape != null) {
                this.frontCape.setHidden(false);
            }
            if (this.leftLegCloth != null) {
                this.leftLegCloth.setHidden(false);
            }
            if (this.rightLegCloth != null) {
                this.rightLegCloth.setHidden(false);
            }
        } else if (currentSlot == class_1304.field_6169 && this.braid != null) {
            this.braid.setHidden(false);
        }
    }

    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        class_1657 player;
        class_1297 class_12972;
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (this.frontCape != null) {
            FARenderUtils.setFrontLegCapeAngle(this, this.frontCape);
        }
        if (this.cape != null) {
            class_12972 = this.currentEntity;
            if (class_12972 instanceof class_1657) {
                player = (class_1657)class_12972;
                FARenderUtils.applyCapeRotation(player, this.cape, partialTick);
            } else {
                this.cape.updateRotation((float)(-Math.toRadians(5.0)), 0.0f, 0.0f);
            }
        }
        if (this.braid != null && (class_12972 = this.currentEntity) instanceof class_1657) {
            player = (class_1657)class_12972;
            FARenderUtils.applyBraidRotation(player, this.braid, partialTick);
        }
    }

    protected void applyBaseTransformations(class_572<?> baseModel) {
        class_630 leftLegPart;
        super.applyBaseTransformations(baseModel);
        if (this.cape != null) {
            class_630 bodyPart = baseModel.field_3391;
            float yPos = this.field_3400 ? bodyPart.field_3656 - 5.5f : bodyPart.field_3656;
            this.cape.updatePosition(bodyPart.field_3657, yPos, bodyPart.field_3655);
        }
        if (this.frontCape != null) {
            leftLegPart = baseModel.field_3397;
            this.frontCape.updatePosition(leftLegPart.field_3657 - 1.95f, 13.0f - leftLegPart.field_3656, leftLegPart.field_3655 - 0.1f);
        }
        if (this.leftLegCloth != null) {
            leftLegPart = baseModel.field_3397;
            RenderUtil.matchModelPartRot((class_630)leftLegPart, (GeoBone)this.leftLegCloth);
            this.leftLegCloth.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
        }
        if (this.rightLegCloth != null) {
            class_630 rightLegPart = baseModel.field_3392;
            RenderUtil.matchModelPartRot((class_630)rightLegPart, (GeoBone)this.rightLegCloth);
            this.rightLegCloth.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
        }
    }

    public void method_2805(boolean pVisible) {
        super.method_2805(pVisible);
        this.setBoneVisible(this.cape, pVisible && FAConfigs.getMainConfig().showCapes);
        this.setBoneVisible(this.frontCape, pVisible);
        this.setBoneVisible(this.leftLegCloth, pVisible);
        this.setBoneVisible(this.rightLegCloth, pVisible);
        this.setBoneVisible(this.braid, pVisible);
    }
}

