/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.config;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.class_1738;

@Config(name="fantasy_armor-attributes")
public class FAArmorAttributesConfig
implements ConfigData {
    @ConfigEntry.Category(value="armor_attributes")
    @ConfigEntry.Gui.CollapsibleObject
    public Map<String, PerSet> bySet = new LinkedHashMap<String, PerSet>();
    private static final Map<FAArmorSet, Map<class_1738.class_8051, FAArmorAttributes>> DEFAULTS = new EnumMap<FAArmorSet, Map<class_1738.class_8051, FAArmorAttributes>>(FAArmorSet.class);

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.bySet == null) {
            this.bySet = new LinkedHashMap<String, PerSet>();
        }
        for (FAArmorSet set : FAArmorSet.values()) {
            String setKey = set.getName();
            PerSet perSet = this.bySet.computeIfAbsent(setKey, k -> new PerSet());
            if (perSet.byPiece == null) {
                perSet.byPiece = new LinkedHashMap<String, Piece>();
            }
            for (class_1738.class_8051 type : class_1738.class_8051.values()) {
                String pieceKey = type.method_48400();
                perSet.byPiece.computeIfAbsent(pieceKey, pk -> {
                    FAArmorAttributes a = null;
                    Map<class_1738.class_8051, FAArmorAttributes> m = DEFAULTS.get((Object)set);
                    if (m != null) {
                        a = m.get(type);
                    }
                    if (a == null) {
                        a = FAArmorAttributesConfig.fallback(type);
                    }
                    Piece p = new Piece();
                    p.armor = a.armor();
                    p.armorToughness = a.armorToughness();
                    p.knockbackResistance = a.knockbackResistance();
                    p.movementSpeed = a.movementSpeed();
                    p.maxHealth = a.maxHealth();
                    p.attackDamage = a.attackDamage();
                    p.attackSpeed = a.attackSpeed();
                    p.luck = a.luck();
                    return p;
                });
            }
        }
    }

    public FAArmorAttributes getAttributes(String setName, String pieceName) {
        PerSet ps = this.bySet.get(setName);
        if (ps == null) {
            return DEFAULTS.getOrDefault((Object)FAArmorAttributesConfig.resolveSet(setName), Map.of()).getOrDefault(FAArmorAttributesConfig.resolveType(pieceName), FAArmorAttributesConfig.fallback(FAArmorAttributesConfig.resolveType(pieceName)));
        }
        Piece piece = ps.byPiece.get(pieceName);
        if (piece == null) {
            return DEFAULTS.getOrDefault((Object)FAArmorAttributesConfig.resolveSet(setName), Map.of()).getOrDefault(FAArmorAttributesConfig.resolveType(pieceName), FAArmorAttributesConfig.fallback(FAArmorAttributesConfig.resolveType(pieceName)));
        }
        return piece.toAttributes();
    }

    private static FAArmorSet resolveSet(String name) {
        for (FAArmorSet s : FAArmorSet.values()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return FAArmorSet.HERO;
    }

    private static class_1738.class_8051 resolveType(String piece) {
        for (class_1738.class_8051 t : class_1738.class_8051.values()) {
            if (!t.method_48400().equals(piece)) continue;
            return t;
        }
        return class_1738.class_8051.field_41934;
    }

    private static FAArmorAttributes fallback(class_1738.class_8051 t) {
        return switch (t) {
            default -> throw new MatchException(null, null);
            case class_1738.class_8051.field_41934, class_1738.class_8051.field_41937 -> new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build();
            case class_1738.class_8051.field_41935, class_1738.class_8051.field_48838 -> new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.1).build();
            case class_1738.class_8051.field_41936 -> new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).build();
        };
    }

    static {
        HashMap<class_1738.class_8051, FAArmorAttributes> eclipseSoldier = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        eclipseSoldier.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).build());
        eclipseSoldier.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).build());
        eclipseSoldier.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        eclipseSoldier.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.ECLIPSE_SOLDIER, eclipseSoldier);
        HashMap<class_1738.class_8051, FAArmorAttributes> dragonslayer = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        dragonslayer.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        dragonslayer.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).build());
        dragonslayer.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        dragonslayer.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DRAGONSLAYER, dragonslayer);
        HashMap<class_1738.class_8051, FAArmorAttributes> hero = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        hero.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackDamage(0.1).attackSpeed(0.1).build());
        hero.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackDamage(0.1).attackSpeed(0.1).build());
        hero.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).build());
        hero.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.HERO, hero);
        HashMap<class_1738.class_8051, FAArmorAttributes> goldenHorns = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        goldenHorns.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).attackSpeed(0.1).build());
        goldenHorns.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.01).attackSpeed(0.1).build());
        goldenHorns.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).build());
        goldenHorns.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.04).build());
        DEFAULTS.put(FAArmorSet.GOLDEN_HORNS, goldenHorns);
        HashMap<class_1738.class_8051, FAArmorAttributes> thief = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        thief.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.1).luck(1.0).build());
        thief.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.1).build());
        thief.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).attackSpeed(0.1).build());
        thief.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.1).attackSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.THIEF, thief);
        HashMap<class_1738.class_8051, FAArmorAttributes> wanderingWizard = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        wanderingWizard.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(2.0).build());
        wanderingWizard.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        wanderingWizard.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        wanderingWizard.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.WANDERING_WIZARD, wanderingWizard);
        HashMap<class_1738.class_8051, FAArmorAttributes> chessBoardKnight = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        chessBoardKnight.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        chessBoardKnight.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        chessBoardKnight.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        chessBoardKnight.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        DEFAULTS.put(FAArmorSet.CHESS_BOARD_KNIGHT, chessBoardKnight);
        HashMap<class_1738.class_8051, FAArmorAttributes> darkLord = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        darkLord.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        darkLord.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        darkLord.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        darkLord.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.DARK_LORD, darkLord);
        HashMap<class_1738.class_8051, FAArmorAttributes> sunsetWings = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        sunsetWings.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        sunsetWings.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).maxHealth(1.0).build());
        DEFAULTS.put(FAArmorSet.SUNSET_WINGS, sunsetWings);
        HashMap<class_1738.class_8051, FAArmorAttributes> fogGuard = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        fogGuard.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        fogGuard.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.01).build());
        fogGuard.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.02).build());
        fogGuard.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.FOG_GUARD, fogGuard);
        HashMap<class_1738.class_8051, FAArmorAttributes> darkCover = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        darkCover.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).build());
        darkCover.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).build());
        darkCover.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        darkCover.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DARK_COVER, darkCover);
        HashMap<class_1738.class_8051, FAArmorAttributes> sparkOfDawn = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        sparkOfDawn.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        sparkOfDawn.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).build());
        sparkOfDawn.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).maxHealth(1.0).attackSpeed(0.05).build());
        sparkOfDawn.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.SPARK_OF_DAWN, sparkOfDawn);
        HashMap<class_1738.class_8051, FAArmorAttributes> goldenExecution = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        goldenExecution.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).attackSpeed(0.05).build());
        goldenExecution.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(4.0).attackSpeed(0.05).build());
        goldenExecution.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        goldenExecution.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        DEFAULTS.put(FAArmorSet.GOLDEN_EXECUTION, goldenExecution);
        HashMap<class_1738.class_8051, FAArmorAttributes> forgottenTrace = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        forgottenTrace.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(1.0).build());
        forgottenTrace.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).maxHealth(2.0).build());
        forgottenTrace.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).maxHealth(1.0).build());
        forgottenTrace.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).maxHealth(1.0).luck(1.0).build());
        DEFAULTS.put(FAArmorSet.FORGOTTEN_TRACE, forgottenTrace);
        HashMap<class_1738.class_8051, FAArmorAttributes> redeemer = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        redeemer.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).attackSpeed(0.05).luck(1.0).build());
        redeemer.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(2.0).attackSpeed(0.03).movementSpeed(0.02).luck(1.0).build());
        redeemer.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.04).build());
        redeemer.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.REDEEMER, redeemer);
        HashMap<class_1738.class_8051, FAArmorAttributes> twinned = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        twinned.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.1).movementSpeed(0.02).build());
        twinned.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).movementSpeed(0.02).build());
        twinned.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).attackSpeed(0.05).movementSpeed(0.02).build());
        twinned.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).movementSpeed(0.02).build());
        DEFAULTS.put(FAArmorSet.TWINNED, twinned);
        HashMap<class_1738.class_8051, FAArmorAttributes> gildedHunt = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        gildedHunt.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        gildedHunt.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).maxHealth(1.0).attackSpeed(0.1).build());
        gildedHunt.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).build());
        gildedHunt.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.GILDED_HUNT, gildedHunt);
        HashMap<class_1738.class_8051, FAArmorAttributes> ladyMaria = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        ladyMaria.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.05).luck(1.0).build());
        ladyMaria.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).attackSpeed(0.05).build());
        ladyMaria.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        ladyMaria.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.LADY_MARIA, ladyMaria);
        HashMap<class_1738.class_8051, FAArmorAttributes> crucibleKnight = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        crucibleKnight.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).build());
        crucibleKnight.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        crucibleKnight.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).build());
        crucibleKnight.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.CRUCIBLE_KNIGHT, crucibleKnight);
        HashMap<class_1738.class_8051, FAArmorAttributes> eveningGhost = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        eveningGhost.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).luck(1.0).build());
        eveningGhost.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).luck(1.0).build());
        eveningGhost.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.04).build());
        eveningGhost.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.EVENING_GHOST, eveningGhost);
        HashMap<class_1738.class_8051, FAArmorAttributes> ronin = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        ronin.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.1).build());
        ronin.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.1).build());
        ronin.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        ronin.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        DEFAULTS.put(FAArmorSet.RONIN, ronin);
        HashMap<class_1738.class_8051, FAArmorAttributes> malenia = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        malenia.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.07).attackSpeed(0.05).build());
        malenia.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).movementSpeed(0.05).attackSpeed(0.05).build());
        malenia.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.05).build());
        malenia.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).movementSpeed(0.08).build());
        DEFAULTS.put(FAArmorSet.MALENIA, malenia);
        HashMap<class_1738.class_8051, FAArmorAttributes> oldKnight = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        oldKnight.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        oldKnight.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(2.0).build());
        oldKnight.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.2).maxHealth(1.0).build());
        oldKnight.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.OLD_KNIGHT, oldKnight);
        HashMap<class_1738.class_8051, FAArmorAttributes> silverKnight = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        silverKnight.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).luck(1.0).attackSpeed(0.03).build());
        silverKnight.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(3.0).knockbackResistance(0.2).luck(1.0).attackSpeed(0.03).build());
        silverKnight.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(3.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        silverKnight.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(3.0).knockbackResistance(0.1).luck(1.0).build());
        DEFAULTS.put(FAArmorSet.SILVER_KNIGHT, silverKnight);
        HashMap<class_1738.class_8051, FAArmorAttributes> deadGladiator = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        deadGladiator.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackDamage(0.05).build());
        deadGladiator.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackDamage(0.1).build());
        deadGladiator.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackDamage(0.05).build());
        deadGladiator.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.DEAD_GLADIATOR, deadGladiator);
        HashMap<class_1738.class_8051, FAArmorAttributes> fleshOfTheFeaster = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        fleshOfTheFeaster.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(1.0).knockbackResistance(0.1).maxHealth(1.0).build());
        fleshOfTheFeaster.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(1.0).knockbackResistance(0.2).maxHealth(2.0).build());
        fleshOfTheFeaster.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(1.0).knockbackResistance(0.1).maxHealth(1.0).build());
        fleshOfTheFeaster.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(1.0).knockbackResistance(0.1).build());
        DEFAULTS.put(FAArmorSet.FLESH_OF_THE_FEASTER, fleshOfTheFeaster);
        HashMap<class_1738.class_8051, FAArmorAttributes> windWorshipper = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        windWorshipper.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.03).build());
        windWorshipper.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        windWorshipper.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        windWorshipper.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.WIND_WORSHIPPER, windWorshipper);
        HashMap<class_1738.class_8051, FAArmorAttributes> graveSentinel = new HashMap<class_1738.class_8051, FAArmorAttributes>();
        graveSentinel.put(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.03).build());
        graveSentinel.put(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.2).attackSpeed(0.03).build());
        graveSentinel.put(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).attackSpeed(0.02).build());
        graveSentinel.put(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.2).movementSpeed(0.03).build());
        DEFAULTS.put(FAArmorSet.GRAVE_SENTINEL, graveSentinel);
        for (FAArmorSet set : FAArmorSet.values()) {
            DEFAULTS.computeIfAbsent(set, s -> new EnumMap(class_1738.class_8051.class));
            Map<class_1738.class_8051, FAArmorAttributes> map = DEFAULTS.get((Object)set);
            map.putIfAbsent(class_1738.class_8051.field_41934, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build());
            map.putIfAbsent(class_1738.class_8051.field_41937, new FAArmorAttributes.Builder().armor(3.0).armorToughness(2.0).knockbackResistance(0.1).build());
            map.putIfAbsent(class_1738.class_8051.field_41935, new FAArmorAttributes.Builder().armor(8.0).armorToughness(2.0).knockbackResistance(0.1).build());
            map.putIfAbsent(class_1738.class_8051.field_41936, new FAArmorAttributes.Builder().armor(6.0).armorToughness(2.0).knockbackResistance(0.1).build());
        }
    }

    public static class PerSet {
        @ConfigEntry.Gui.CollapsibleObject
        public Map<String, Piece> byPiece = new LinkedHashMap<String, Piece>();
    }

    public static class Piece {
        public double armor = 0.0;
        public double armorToughness = 0.0;
        public double knockbackResistance = 0.0;
        public double movementSpeed = 0.0;
        public double maxHealth = 0.0;
        public double attackDamage = 0.0;
        public double attackSpeed = 0.0;
        public double luck = 0.0;

        public FAArmorAttributes toAttributes() {
            return new FAArmorAttributes.Builder().armor(this.armor).armorToughness(this.armorToughness).knockbackResistance(this.knockbackResistance).movementSpeed(this.movementSpeed).maxHealth(this.maxHealth).attackDamage(this.attackDamage).attackSpeed(this.attackSpeed).luck(this.luck).build();
        }
    }
}

