/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kenddie.fantasyarmor.config.FAConfigs;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;

public class FAArmorEffectHandler {
    public static void register() {
        ServerTickEvents.START_WORLD_TICK.register(FAArmorEffectHandler::onWorldTick);
    }

    private static void onWorldTick(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            if (!FAConfigs.getMainConfig().applyArmorEffects || !FAArmorEffectHandler.hasFullSet((class_1657)player)) continue;
            FAArmorEffectHandler.applyFullSetEffects((class_1657)player);
        }
    }

    private static boolean hasFullSet(class_1657 player) {
        class_1799 helmetItemStack = player.method_6118(class_1304.field_6169);
        class_1799 chestplateItemStack = player.method_6118(class_1304.field_6174);
        class_1799 leggingsItemStack = player.method_6118(class_1304.field_6172);
        class_1799 bootsItemStack = player.method_6118(class_1304.field_6166);
        if (helmetItemStack.method_7909() instanceof FAArmorItem && chestplateItemStack.method_7909() instanceof FAArmorItem && leggingsItemStack.method_7909() instanceof FAArmorItem && bootsItemStack.method_7909() instanceof FAArmorItem) {
            Class<?> armorClass = helmetItemStack.method_7909().getClass();
            return armorClass.isInstance(chestplateItemStack.method_7909()) && armorClass.isInstance(leggingsItemStack.method_7909()) && armorClass.isInstance(bootsItemStack.method_7909());
        }
        return false;
    }

    private static void applyFullSetEffects(class_1657 player) {
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        FAArmorItem armorItem = (FAArmorItem)helmet.method_7909();
        for (class_1293 effectInstance : armorItem.getFullSetEffects()) {
            class_6880 effectHolder = effectInstance.method_5579();
            class_1293 existingEffect = player.method_6112(effectHolder);
            if (existingEffect != null && existingEffect.method_5584() >= FAConfigs.getMainConfig().effectsInterval) continue;
            player.method_6092(new class_1293(effectHolder, effectInstance.method_5584(), effectInstance.method_5578(), true, FAConfigs.getMainConfig().showParticles, FAConfigs.getMainConfig().showEffectIcon));
        }
    }
}

