/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.item.armor;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kenddie.fantasyarmor.client.armor.model.FAArmorModel;
import net.kenddie.fantasyarmor.client.armor.render.FAArmorRenderer;
import net.kenddie.fantasyarmor.config.FAArmorEffectsConfig;
import net.kenddie.fantasyarmor.config.FAConfigs;
import net.kenddie.fantasyarmor.item.armor.FAArmorAttributes;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5134;
import net.minecraft.class_572;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public abstract class FAArmorItem
extends class_1738
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final FAArmorSet armorSet;
    private final Supplier<FAArmorAttributes> attributesSupplier;
    private class_9285 cachedModifiers;

    protected FAArmorItem(FAArmorSet armorSet, class_1738.class_8051 type, Supplier<FAArmorAttributes> attributesSupplier) {
        super(class_1740.field_21977, type, new class_1792.class_1793().method_7889(1).method_24359());
        this.armorSet = armorSet;
        this.attributesSupplier = attributesSupplier;
    }

    public void method_7851(@NotNull class_1799 pStack, @NotNull class_1792.class_9635 pContext, @NotNull List<class_2561> pTooltipComponents, @NotNull class_1836 pTooltipFlag) {
        String[] lines;
        if (!FAConfigs.getMainConfig().showDescriptions) {
            return;
        }
        super.method_7851(pStack, pContext, pTooltipComponents, pTooltipFlag);
        String translationKey = this.method_7876() + ".tooltip";
        String translatedText = class_2561.method_43471((String)translationKey).getString();
        class_327 font = class_310.method_1551().field_1772;
        for (String line : lines = translatedText.split("\n")) {
            String[] words;
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = line.split(" ")) {
                if (font.method_1727(String.valueOf(currentLine) + word) > FAConfigs.getMainConfig().descriptionsLength) {
                    pTooltipComponents.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
                    currentLine = new StringBuilder();
                    currentLine.append("\u00a77");
                }
                if (currentLine.length() > 2) {
                    currentLine.append(" ");
                    currentLine.append("\u00a77");
                }
                currentLine.append(word);
            }
            if (currentLine.length() <= 0) continue;
            pTooltipComponents.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
        }
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<? extends FAArmorItem> renderer;

            public <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                if (this.renderer == null) {
                    this.renderer = FAArmorItem.this.createArmorRenderer();
                }
                return this.renderer;
            }
        });
    }

    public class_9285 method_7844() {
        if (!FAConfigs.getMainConfig().applyModifiers) {
            return super.method_7844();
        }
        if (this.cachedModifiers == null) {
            this.cachedModifiers = this.buildModifiers();
        }
        return this.cachedModifiers;
    }

    private class_9285 buildModifiers() {
        FAArmorAttributes armorAttributes = this.attributesSupplier.get();
        class_9285.class_9286 builder = class_9285.method_57480();
        class_9274 slotGroup = class_9274.method_59524((class_1304)this.field_41933.method_48399());
        String slotName = this.field_41933.method_48400();
        if (armorAttributes.armor() != 0.0) {
            builder.method_57487(class_5134.field_23724, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_armor")), armorAttributes.armor(), class_1322.class_1323.field_6328), slotGroup);
        }
        if (armorAttributes.armorToughness() != 0.0) {
            builder.method_57487(class_5134.field_23725, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_armor_toughness")), armorAttributes.armorToughness(), class_1322.class_1323.field_6328), slotGroup);
        }
        if (armorAttributes.knockbackResistance() != 0.0) {
            builder.method_57487(class_5134.field_23718, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_knockback")), armorAttributes.knockbackResistance(), class_1322.class_1323.field_6328), slotGroup);
        }
        if (armorAttributes.movementSpeed() != 0.0) {
            builder.method_57487(class_5134.field_23719, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_speed")), armorAttributes.movementSpeed(), class_1322.class_1323.field_6331), slotGroup);
        }
        if (armorAttributes.maxHealth() != 0.0) {
            builder.method_57487(class_5134.field_23716, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_health")), armorAttributes.maxHealth(), class_1322.class_1323.field_6328), slotGroup);
        }
        if (armorAttributes.attackDamage() != 0.0) {
            builder.method_57487(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_attack_damage")), armorAttributes.attackDamage(), class_1322.class_1323.field_6331), slotGroup);
        }
        if (armorAttributes.attackSpeed() != 0.0) {
            builder.method_57487(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_attack_speed")), armorAttributes.attackSpeed(), class_1322.class_1323.field_6331), slotGroup);
        }
        if (armorAttributes.luck() != 0.0) {
            builder.method_57487(class_5134.field_23726, new class_1322(class_2960.method_60655((String)"fantasy_armor", (String)(slotName + "_luck")), armorAttributes.luck(), class_1322.class_1323.field_6328), slotGroup);
        }
        return builder.method_57486();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Environment(value=EnvType.CLIENT)
    protected GeoArmorRenderer<? extends FAArmorItem> createArmorRenderer() {
        return new FAArmorRenderer(new FAArmorModel(this.armorSet.getGeoPath(), this.armorSet.getTexturePath()));
    }

    public List<class_1293> getFullSetEffects() {
        return FAArmorEffectsConfig.getEffectsFor(this.armorSet.getName(), FAConfigs.getMainConfig().showParticles, FAConfigs.getMainConfig().showEffectIcon);
    }
}

