/*
 * Decompiled with CFR 0.152.
 */
package me.shreyjain.seaCreatures.command;

import java.util.ArrayList;
import java.util.List;
import me.shreyjain.seaCreatures.SeaCreatures;
import me.shreyjain.seaCreatures.creature.SeaCreatureManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class SeaCreaturesCommand
implements CommandExecutor,
TabCompleter {
    private final SeaCreatures plugin;
    private final SeaCreatureManager manager;

    public SeaCreaturesCommand(SeaCreatures plugin, SeaCreatureManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "SeaCreatures " + String.valueOf(ChatColor.GRAY) + "- Loaded definitions: " + this.manager.getDefinitions().size());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " reload" + String.valueOf(ChatColor.GRAY) + " - reload config");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("seacreatures.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission.");
                return true;
            }
            long start = System.currentTimeMillis();
            this.manager.reload();
            long took = System.currentTimeMillis() - start;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "SeaCreatures reloaded (" + this.manager.getDefinitions().size() + " defs, " + took + "ms).");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Try /" + label + " reload");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (args.length == 1 && "reload".startsWith(args[0].toLowerCase()) && sender.hasPermission("seacreatures.reload")) {
            out.add("reload");
        }
        return out;
    }
}

