/*
 * Decompiled with CFR 0.152.
 */
package me.shreyjain.seaCreatures.creature;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffect;

public class SeaCreatureDefinition {
    private final String id;
    private final EntityType type;
    private final int weight;
    private final boolean custom;
    private final String displayName;
    private final boolean glowing;
    private final List<PotionEffect> potionEffects;
    private final Map<EquipmentSlotSimple, String> equipmentMaterials;
    private final List<String> commands;
    private final Integer minY;
    private final Integer maxY;
    private final Set<String> biomes;
    private final Set<String> worlds;
    private final double fishingXp;
    private final List<Drop> drops;
    private final boolean replaceDefaultDrops;

    public SeaCreatureDefinition(String id, EntityType type, int weight, boolean custom, String displayName, boolean glowing, List<PotionEffect> potionEffects, Map<EquipmentSlotSimple, String> equipmentMaterials, List<String> commands, Integer minY, Integer maxY, Set<String> biomes, Set<String> worlds, double fishingXp, List<Drop> drops, boolean replaceDefaultDrops) {
        this.id = id;
        this.type = type;
        this.weight = weight <= 0 ? 1 : weight;
        this.custom = custom;
        this.displayName = displayName;
        this.glowing = glowing;
        this.potionEffects = potionEffects;
        this.equipmentMaterials = equipmentMaterials;
        this.commands = commands;
        this.minY = minY;
        this.maxY = maxY;
        this.biomes = biomes;
        this.worlds = worlds;
        this.fishingXp = fishingXp;
        this.drops = drops;
        this.replaceDefaultDrops = replaceDefaultDrops;
    }

    public String getId() {
        return this.id;
    }

    public EntityType getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public Map<EquipmentSlotSimple, String> getEquipmentMaterials() {
        return this.equipmentMaterials;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Integer getMinY() {
        return this.minY;
    }

    public Integer getMaxY() {
        return this.maxY;
    }

    public Set<String> getBiomes() {
        return this.biomes;
    }

    public Set<String> getWorlds() {
        return this.worlds;
    }

    public double getFishingXp() {
        return this.fishingXp;
    }

    public List<Drop> getDrops() {
        return this.drops;
    }

    public boolean isReplaceDefaultDrops() {
        return this.replaceDefaultDrops;
    }

    public static class Drop {
        private final String material;
        private final Integer min;
        private final Integer max;
        private final String command;
        private final double chance;
        private final String label;

        public Drop(String material, Integer min, Integer max, String command, double chance, String label) {
            this.material = material;
            this.min = min;
            this.max = max;
            this.command = command;
            this.chance = Math.max(0.0, Math.min(1.0, chance));
            this.label = label != null ? label : (material != null ? material : command);
        }

        public boolean isCommand() {
            return this.command != null;
        }

        public String getMaterial() {
            return this.material;
        }

        public int getMin() {
            return this.min == null ? 1 : this.min;
        }

        public int getMax() {
            return this.max == null ? this.getMin() : Math.max(this.getMin(), this.max);
        }

        public String getCommand() {
            return this.command;
        }

        public double getChance() {
            return this.chance;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum EquipmentSlotSimple {
        HAND,
        OFF_HAND,
        HEAD,
        CHEST,
        LEGS,
        FEET;

    }
}

