/*
 * Decompiled with CFR 0.152.
 */
package me.shreyjain.seaCreatures.creature;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.user.SkillsUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.shreyjain.seaCreatures.SeaCreatures;
import me.shreyjain.seaCreatures.creature.SeaCreatureDefinition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SeaCreatureManager {
    private final SeaCreatures plugin;
    private final List<SeaCreatureDefinition> definitions = new ArrayList<SeaCreatureDefinition>();
    private double baseChancePercent;
    private double perLuckLevelBonus;
    private LogLevel logLevel = LogLevel.INFO;
    private boolean auraEnabled;
    private double defaultFishingXp;
    private double fishingLuckBonusPerLevel;
    private AuraSkillsApi auraSkillsApi;
    private final Map<UUID, SpawnedCreature> spawnedCreatures = new HashMap<UUID, SpawnedCreature>();

    public SeaCreatureManager(SeaCreatures plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.definitions.clear();
        FileConfiguration cfg = this.plugin.getConfig();
        this.baseChancePercent = cfg.getDouble("chance.base-percent", 25.0);
        this.perLuckLevelBonus = cfg.getDouble("chance.per-luck-level-bonus", 2.0);
        this.logLevel = LogLevel.from(cfg.getString("logging", "INFO"));
        boolean bl = this.auraEnabled = cfg.getBoolean("auraskills.enabled", true) && Bukkit.getPluginManager().isPluginEnabled("AuraSkills");
        if (this.auraEnabled) {
            try {
                this.auraSkillsApi = AuraSkillsApi.get();
            }
            catch (Throwable t) {
                this.auraEnabled = false;
                this.plugin.getLogger().warning("AuraSkills API not accessible; disabling integration.");
            }
        }
        this.defaultFishingXp = cfg.getDouble("auraskills.xp.default-per-creature", 10.0);
        this.fishingLuckBonusPerLevel = cfg.getDouble("auraskills.stats.fishing-luck-bonus-per-level", 0.1);
        List list = cfg.getMapList("creatures");
        for (Map raw : list) {
            try {
                SeaCreatureDefinition def = this.parse(raw);
                if (def == null) continue;
                this.definitions.add(def);
            }
            catch (Exception ex) {
                this.log(Level.WARNING, "Failed to parse creature: " + String.valueOf(raw) + " => " + ex.getMessage());
            }
        }
        this.log(Level.INFO, "Loaded " + this.definitions.size() + " sea creature definitions.");
    }

    private SeaCreatureDefinition parse(Map<?, ?> map) {
        EntityType type;
        String idObj = map.containsKey("id") ? map.get("id") : UUID.randomUUID().toString();
        String id = String.valueOf(idObj);
        String typeName = String.valueOf(map.get("type"));
        try {
            type = EntityType.valueOf((String)typeName.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Unknown entity type '" + typeName + "' for id=" + id);
            return null;
        }
        int weight = this.asInt(map.get("weight"), 1);
        boolean custom = this.asBool(map.get("custom"), false);
        String name = map.containsKey("display-name") ? String.valueOf(map.get("display-name")) : null;
        boolean glowing = this.asBool(map.get("glowing"), false);
        Integer minY = map.containsKey("min-y") ? Integer.valueOf(this.asInt(map.get("min-y"), Integer.MIN_VALUE)) : null;
        Integer maxY = map.containsKey("max-y") ? Integer.valueOf(this.asInt(map.get("max-y"), Integer.MAX_VALUE)) : null;
        Set<String> biomes = map.containsKey("biomes") ? this.toUpperSet(map.get("biomes")) : null;
        Set<String> worlds = map.containsKey("worlds") ? this.toStringSet(map.get("worlds")) : null;
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        Object peRaw = map.get("potion-effects");
        if (peRaw instanceof List) {
            List peList = (List)peRaw;
            for (Object lineObj : peList) {
                PotionEffectType typePE;
                String line = String.valueOf(lineObj);
                String[] stringArray = line.split(":");
                if (stringArray.length < 3 || (typePE = PotionEffectType.getByName((String)stringArray[0].toUpperCase(Locale.ROOT))) == null) continue;
                int amp = this.parseInt(stringArray[1], 0);
                int dur = this.parseInt(stringArray[2], 200);
                potionEffects.add(new PotionEffect(typePE, dur, amp));
            }
        }
        EnumMap<SeaCreatureDefinition.EquipmentSlotSimple, String> equipment = new EnumMap<SeaCreatureDefinition.EquipmentSlotSimple, String>(SeaCreatureDefinition.EquipmentSlotSimple.class);
        Object eqRaw = map.get("equipment");
        if (eqRaw instanceof Map) {
            Map eqMap = (Map)eqRaw;
            for (Map.Entry entry : eqMap.entrySet()) {
                try {
                    SeaCreatureDefinition.EquipmentSlotSimple slot = SeaCreatureDefinition.EquipmentSlotSimple.valueOf(entry.getKey().toString().toUpperCase(Locale.ROOT));
                    equipment.put(slot, entry.getValue().toString().toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {}
            }
        }
        ArrayList<String> commands = new ArrayList<String>();
        Object cmdRaw = map.get("commands");
        if (cmdRaw instanceof List) {
            List list = (List)cmdRaw;
            for (Object c : list) {
                commands.add(String.valueOf(c));
            }
        }
        double d = this.defaultFishingXp;
        if (map.containsKey("fishing-xp")) {
            try {
                d = Double.parseDouble(String.valueOf(map.get("fishing-xp")));
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        ArrayList<SeaCreatureDefinition.Drop> drops = new ArrayList<SeaCreatureDefinition.Drop>();
        boolean replaceDefaultDrops = false;
        Object dropsRaw = map.get("drops");
        if (dropsRaw instanceof Map) {
            Map dropsMap = (Map)dropsRaw;
            replaceDefaultDrops = this.asBool(dropsMap.get("replace-default"), false);
            Object items = dropsMap.get("items");
            if (items instanceof List) {
                List itemList = (List)items;
                for (Object itemObj : itemList) {
                    String line;
                    double chance;
                    int max;
                    int min;
                    if (itemObj instanceof Map) {
                        String label;
                        String command;
                        Map im = (Map)itemObj;
                        String material = im.containsKey("material") ? String.valueOf(im.get("material")) : null;
                        String string = command = im.containsKey("command") ? String.valueOf(im.get("command")) : null;
                        if (material == null && command == null) continue;
                        min = material != null ? this.asInt(im.get("min"), 1) : 1;
                        max = material != null ? this.asInt(im.get("max"), min) : 1;
                        chance = this.parseDouble(im.get("chance"), 1.0);
                        String string2 = label = im.containsKey("label") ? String.valueOf(im.get("label")) : null;
                        if (material != null) {
                            material = material.toUpperCase(Locale.ROOT);
                        }
                        drops.add(new SeaCreatureDefinition.Drop(material, min, max, command, chance, label));
                        continue;
                    }
                    if (itemObj == null || (line = String.valueOf(itemObj).trim()).isEmpty()) continue;
                    String matPart = line;
                    min = 1;
                    max = 1;
                    chance = 1.0;
                    String[] segs = line.split(":");
                    if (segs.length > 0) {
                        matPart = segs[0];
                    }
                    if (segs.length > 1) {
                        String[] range = segs[1].split("-");
                        if (range.length == 2) {
                            min = this.parseInt(range[0], 1);
                            max = this.parseInt(range[1], min);
                        } else {
                            int v;
                            min = v = this.parseInt(segs[1], 1);
                            max = v;
                        }
                    }
                    if (segs.length > 2) {
                        chance = this.parseDouble(segs[2], 1.0);
                    }
                    drops.add(new SeaCreatureDefinition.Drop(matPart.toUpperCase(Locale.ROOT), min, max, null, chance, null));
                }
            }
        }
        return new SeaCreatureDefinition(id, type, weight, custom, name, glowing, potionEffects, equipment, commands, minY, maxY, biomes, worlds, d, drops, replaceDefaultDrops);
    }

    private int asInt(Object o, int def) {
        int n;
        if (o instanceof Number) {
            Number n2 = (Number)o;
            n = n2.intValue();
        } else {
            n = this.parseInt(String.valueOf(o), def);
        }
        return n;
    }

    private boolean asBool(Object o, boolean def) {
        return o == null ? def : Boolean.parseBoolean(String.valueOf(o));
    }

    private int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private double parseDouble(Object o, double def) {
        if (o == null) {
            return def;
        }
        try {
            return Double.parseDouble(String.valueOf(o));
        }
        catch (Exception e) {
            return def;
        }
    }

    private Set<String> toUpperSet(Object o) {
        if (!(o instanceof List)) {
            return null;
        }
        List list = (List)o;
        return list.stream().map(v -> v.toString().toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    private Set<String> toStringSet(Object o) {
        if (!(o instanceof List)) {
            return null;
        }
        List list = (List)o;
        return list.stream().map(Object::toString).collect(Collectors.toSet());
    }

    public List<SeaCreatureDefinition> getDefinitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    public double computeChancePercent(int luckLevel) {
        double v = this.baseChancePercent + this.perLuckLevelBonus * (double)luckLevel;
        return Math.max(0.0, Math.min(100.0, v));
    }

    public SeaCreatureDefinition pickRandom(Location loc) {
        if (this.definitions.isEmpty()) {
            return null;
        }
        World world = loc.getWorld();
        int y = loc.getBlockY();
        Biome biome = world.getBiome(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        List<SeaCreatureDefinition> filtered = this.definitions.stream().filter(d -> {
            if (d.getMinY() != null && y < d.getMinY()) {
                return false;
            }
            if (d.getMaxY() != null && y > d.getMaxY()) {
                return false;
            }
            if (d.getWorlds() != null && !d.getWorlds().contains(world.getName())) {
                return false;
            }
            return d.getBiomes() == null || d.getBiomes().contains(biome.name().toUpperCase(Locale.ROOT));
        }).toList();
        if (filtered.isEmpty()) {
            return null;
        }
        int total = filtered.stream().mapToInt(SeaCreatureDefinition::getWeight).sum();
        int r = ThreadLocalRandom.current().nextInt(total) + 1;
        int cumulative = 0;
        for (SeaCreatureDefinition def : filtered) {
            if (r > (cumulative += def.getWeight())) continue;
            return def;
        }
        return filtered.get(filtered.size() - 1);
    }

    public LivingEntity spawn(Location loc, SeaCreatureDefinition def, Player fisher) {
        Entity entity = loc.getWorld().spawnEntity(loc, def.getType());
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)entity;
        if (def.getDisplayName() != null) {
            String legacy = ChatColor.translateAlternateColorCodes((char)'&', (String)def.getDisplayName());
            living.setCustomName(legacy);
            living.setCustomNameVisible(true);
        }
        living.setGlowing(def.isGlowing());
        for (PotionEffect effect : def.getPotionEffects()) {
            living.addPotionEffect(effect);
        }
        if (!def.getEquipmentMaterials().isEmpty() && living instanceof Mob) {
            Mob mob = (Mob)living;
            EntityEquipment equip = mob.getEquipment();
            def.getEquipmentMaterials().forEach((slot, matName) -> {
                try {
                    Material material = Material.valueOf((String)matName);
                    ItemStack stack = new ItemStack(material);
                    switch (slot) {
                        case HAND: {
                            equip.setItemInMainHand(stack);
                            break;
                        }
                        case OFF_HAND: {
                            equip.setItemInOffHand(stack);
                            break;
                        }
                        case HEAD: {
                            equip.setHelmet(stack);
                            break;
                        }
                        case CHEST: {
                            equip.setChestplate(stack);
                            break;
                        }
                        case LEGS: {
                            equip.setLeggings(stack);
                            break;
                        }
                        case FEET: {
                            equip.setBoots(stack);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        for (String cmd : def.getCommands()) {
            String finalCmd = cmd.replace("%player%", fisher.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCmd);
        }
        this.spawnedCreatures.put(living.getUniqueId(), new SpawnedCreature(def, fisher.getUniqueId()));
        this.log(Level.FINE, "Spawned sea creature id=" + def.getId() + " for " + fisher.getName());
        return living;
    }

    public void handleDeath(EntityDeathEvent event) {
        List<SeaCreatureDefinition.Drop> customDrops;
        UUID owner;
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        SpawnedCreature sc = this.spawnedCreatures.remove(entity.getUniqueId());
        if (sc == null) {
            return;
        }
        SeaCreatureDefinition def = sc.definition();
        Player recipient = killer;
        if (recipient == null && (owner = sc.owner()) != null) {
            recipient = Bukkit.getPlayer((UUID)owner);
        }
        if (!(customDrops = def.getDrops()).isEmpty()) {
            if (def.isReplaceDefaultDrops()) {
                event.getDrops().clear();
            }
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            for (SeaCreatureDefinition.Drop d : customDrops) {
                boolean rare;
                if (!(rng.nextDouble() <= d.getChance())) continue;
                boolean bl = rare = d.getChance() < 0.05;
                if (d.isCommand()) {
                    if (recipient == null) continue;
                    String cmd = d.getCommand().replace("%player%", recipient.getName());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
                    if (!rare || !recipient.isOnline()) continue;
                    this.sendRareMessage(recipient, d.getLabel());
                    continue;
                }
                int amount = d.getMin() == d.getMax() ? d.getMin() : rng.nextInt(d.getMin(), d.getMax() + 1);
                try {
                    Material mat = Material.valueOf((String)d.getMaterial());
                    if (amount > 0) {
                        event.getDrops().add(new ItemStack(mat, amount));
                    }
                    if (!rare || recipient == null || !recipient.isOnline()) continue;
                    this.sendRareMessage(recipient, d.getLabel());
                }
                catch (Exception exception) {}
            }
        }
        if (this.auraEnabled && this.auraSkillsApi != null && recipient != null) {
            try {
                double xp;
                SkillsUser user = this.auraSkillsApi.getUser(recipient.getUniqueId());
                if (user != null && (xp = def.getFishingXp()) > 0.0) {
                    user.addSkillXp((Skill)Skills.FISHING, xp);
                    recipient.sendMessage(String.valueOf(ChatColor.GREEN) + "+" + xp + " Fishing XP");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void log(Level level, String msg) {
        if (this.logLevel == LogLevel.NONE) {
            return;
        }
        if (this.logLevel == LogLevel.INFO && level == Level.FINE) {
            return;
        }
        this.plugin.getLogger().log(level, msg);
    }

    public double getAdditionalFishingLuckChance(Player player) {
        if (!this.auraEnabled || this.auraSkillsApi == null) {
            return 0.0;
        }
        try {
            SkillsUser user = this.auraSkillsApi.getUser(player.getUniqueId());
            if (user == null) {
                return 0.0;
            }
            double statLevel = user.getStatLevel((Stat)Stats.LUCK);
            return statLevel * this.fishingLuckBonusPerLevel;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private void sendRareMessage(Player player, String label) {
        try {
            String template = this.plugin.getConfig().getString("messages.rare-drop", "&6RARE DROP! &eYou obtained: &b%item%");
            String msg = template.replace("%item%", label == null ? "UNKNOWN" : label);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAuraEnabled() {
        return this.auraEnabled;
    }

    static enum LogLevel {
        INFO,
        DEBUG,
        NONE;


        static LogLevel from(String s) {
            try {
                return LogLevel.valueOf(s.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return INFO;
            }
        }
    }

    private record SpawnedCreature(SeaCreatureDefinition definition, UUID owner) {
    }
}

