/*
 * Decompiled with CFR 0.152.
 */
package me.shreyjain.seaCreatures.listener;

import java.util.concurrent.ThreadLocalRandom;
import me.shreyjain.seaCreatures.SeaCreatures;
import me.shreyjain.seaCreatures.creature.SeaCreatureDefinition;
import me.shreyjain.seaCreatures.creature.SeaCreatureManager;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FishingListener
implements Listener {
    private final SeaCreatures plugin;
    private final SeaCreatureManager manager;

    public FishingListener(SeaCreatures plugin, SeaCreatureManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @EventHandler(ignoreCancelled=true)
    public void onFish(PlayerFishEvent event) {
        LivingEntity spawned;
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        int luckLevel = 0;
        ItemStack rod = player.getInventory().getItemInMainHand();
        if (rod.getType() == Material.FISHING_ROD) {
            luckLevel = rod.getEnchantmentLevel(Enchantment.LUCK_OF_THE_SEA);
        }
        double chance = this.manager.computeChancePercent(luckLevel);
        if ((chance += this.manager.getAdditionalFishingLuckChance(player)) < 0.0) {
            chance = 0.0;
        } else if (chance > 100.0) {
            chance = 100.0;
        }
        if (ThreadLocalRandom.current().nextDouble(100.0) > chance) {
            return;
        }
        Location spawnLoc = event.getHook().getLocation().clone();
        SeaCreatureDefinition def = this.manager.pickRandom(spawnLoc);
        if (def == null) {
            return;
        }
        Entity caught = event.getCaught();
        if (caught != null) {
            caught.remove();
        }
        if ((spawned = this.manager.spawn(spawnLoc, def, player)) != null) {
            String raw = def.getDisplayName() != null ? def.getDisplayName() : def.getType().name();
            String plain = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)raw));
            String msg = this.plugin.getConfig().getString("messages.catch", "&bYou fished up a &e%creature%&b!").replace("%creature%", plain);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            try {
                Location playerMid = player.getLocation().add(0.0, 0.5, 0.0);
                Vector toPlayer = playerMid.toVector().subtract(spawned.getLocation().toVector());
                double distance = toPlayer.length();
                if (distance > 1.0E-4) {
                    toPlayer.normalize();
                    double speed = Math.min(1.2, 0.35 + distance * 0.15);
                    Vector velocity = toPlayer.multiply(speed);
                    velocity.setY(Math.min(0.9, Math.max(0.35, distance * 0.1)));
                    spawned.setVelocity(velocity);
                }
                if (spawned instanceof Mob) {
                    Mob mob = (Mob)spawned;
                    mob.setTarget((LivingEntity)player);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

