/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.dodges;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.DodgeLocationIndicator;

public class SpecialCancelableDodgeAnimation
extends ActionAnimation {
    public SpecialCancelableDodgeAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends SpecialCancelableDodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        this(convertTime, Float.MAX_VALUE, accessor, width, height, armature);
    }

    public SpecialCancelableDodgeAnimation(float convertTime, float end, AnimationManager.AnimationAccessor<? extends SpecialCancelableDodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        this(convertTime, end, end, end, accessor, width, height, armature);
    }

    public SpecialCancelableDodgeAnimation(float convertTime, float canBasicAndskill, float end, AnimationManager.AnimationAccessor<? extends SpecialCancelableDodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        this(convertTime, canBasicAndskill, canBasicAndskill, end, accessor, width, height, armature);
    }

    public SpecialCancelableDodgeAnimation(float convertTime, float canBasic, float canSkill, float end, AnimationManager.AnimationAccessor<? extends SpecialCancelableDodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        super(convertTime, 0.0f, accessor, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, canBasic).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(0.0f, canSkill).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, (Object)false).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.INACTION, (Object)true).newTimePair(0.0f, end).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.ATTACK_RESULT, damagesource -> {
            if (!(damagesource.m_7639_() == null || damagesource.m_276093_(DamageTypes.f_268515_) || damagesource.m_269533_(DamageTypeTags.f_268490_) || damagesource.m_269533_(DamageTypeTags.f_268738_) || damagesource.m_269533_(EpicFightDamageTypeTags.BYPASS_DODGE))) {
                return AttackResult.ResultType.MISSED;
            }
            return AttackResult.ResultType.SUCCESS;
        });
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, true);
        if (width >= 0.0f && height >= 0.0f) {
            this.addEvents(new AnimationEvent[]{AnimationEvent.SimpleEvent.create((AnimationEvent.Event)Animations.ReusableSources.RESIZE_BOUNDING_BOX, (AnimationEvent.Side)AnimationEvent.Side.BOTH).params((Object)EntityDimensions.m_20395_((float)width, (float)height))});
            this.addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((AnimationEvent.Event)Animations.ReusableSources.RESTORE_BOUNDING_BOX, (AnimationEvent.Side)AnimationEvent.Side.BOTH)});
        }
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && entitypatch != null) {
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7967_((Entity)new DodgeLocationIndicator(entitypatch));
        }
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch.isLogicalClient() && entitypatch instanceof LocalPlayerPatch) {
            EpicFightNetworkManager.sendToServer((Object)new CPModifyEntityModelYRot(0.0f));
        }
    }
}

