/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.ClassicMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class BeamUpParticle
extends CustomModelParticle<ClassicMesh> {
    private final float length;
    private final float xRot;
    private final float yRot;

    public BeamUpParticle(ClientLevel level, double x, double y, double z, double toX, double toY, double toZ) {
        super(level, x, y, z, 0.0, 0.0, 0.0, (AssetAccessor)Meshes.LASER);
        this.f_107225_ = 10;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        Vec3 direction = new Vec3(0.0, 1.0, 0.0);
        Vec3 start = new Vec3(x, y, z);
        Vec3 destination = start.m_82549_(direction.m_82541_().m_82490_(50.0));
        BlockHitResult hitResult = level.m_45547_(new ClipContext(start, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        double xLength = hitResult.m_82450_().f_82479_ - x;
        double yLength = hitResult.m_82450_().f_82480_ - y;
        double zLength = hitResult.m_82450_().f_82481_ - z;
        double horizontalDistance = (float)Math.sqrt(xLength * xLength + zLength * zLength);
        this.length = (float)Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
        this.yRot = (float)(-Math.atan2(zLength, xLength) * 57.29577951308232) - 90.0f;
        this.xRot = (float)(Math.atan2(yLength, horizontalDistance) * 57.29577951308232);
        int pCount = (int)this.length * 4;
        for (int i = 0; i < pCount; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x + new Random().nextGaussian() * (double)0.4f + xLength / (double)pCount * (double)i, y + new Random().nextGaussian() * (double)0.4f + yLength / (double)pCount * (double)i, z + new Random().nextGaussian() * (double)0.4f + zLength / (double)pCount * (double)i, 0.0, 0.0, 0.0);
        }
        int n = 60;
        double r = 0.6;
        double t = 0.01;
        for (int i = 0; i < n; ++i) {
            double theta = Math.PI * 2 * new Random().nextDouble();
            double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
            double px = r * Math.cos(phi) * Math.cos(theta);
            double py = r * Math.cos(phi) * Math.sin(theta);
            double pz = r * Math.sin(phi);
            Vec3f pdirection = new Vec3f((float)px, (float)py, (float)pz);
            OpenMatrix4f rotation = new OpenMatrix4f().rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)pdirection, (Vec3f)pdirection);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)(pdirection.x * 2.0f) + start.f_82479_, (double)(pdirection.y * 2.0f) + start.f_82480_ + 0.5, (double)(pdirection.z * 2.0f) + start.f_82481_, (double)(pdirection.x * 0.2f), (double)(pdirection.y * 0.2f - 0.02f), (double)(pdirection.z * 0.2f));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)(pdirection.x * 0.7f) + start.f_82479_, (double)(pdirection.y * 0.7f) + start.f_82480_ + 1.5, (double)(pdirection.z * 0.7f) + start.f_82481_, (double)(pdirection.x * 0.1f), (double)(pdirection.y * 0.1f - 0.02f), (double)(pdirection.z * 0.1f));
        }
        this.m_107259_(new AABB(x, y, z, toX, toY, toZ));
    }

    public void prepareDraw(PoseStack poseStack, float partialTicks) {
        poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(this.yRot));
        poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(this.xRot));
        float progression = ((float)this.f_107224_ + partialTicks) / (float)(this.f_107225_ + 1);
        float scale = Mth.m_14031_((float)(progression * (float)Math.PI)) * 1.2f;
        float zScale = Mth.m_14031_((float)(progression * (float)Math.PI));
        poseStack.m_85841_(scale, scale, zScale * this.length);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        super.m_5744_(vertexConsumer, camera, partialTicks);
        PoseStack poseStack = new PoseStack();
        this.setupPoseStack(poseStack, camera, partialTicks);
        this.prepareDraw(poseStack, partialTicks);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.TRANSLUCENT_GLOWING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double startX, double startY, double startZ, double endX, double endY, double endZ) {
            return new BeamUpParticle(level, startX, startY, startZ, endX, endY, endZ);
        }
    }
}

