/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.renderer;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.model.armature.types.ToolHolderArmature;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@OnlyIn(value=Dist.CLIENT)
public class RenderHerrscher
extends RenderItemBase {
    private final ItemStack Aura = new ItemStack((ItemLike)WOMItems.HERRSCHER_AURA.get());

    public RenderHerrscher(JsonElement jsonElement) {
        super(jsonElement);
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Armature armature = entitypatch.getArmature();
        if (armature instanceof ToolHolderArmature) {
            PlayerPatch player;
            ToolHolderArmature armature2 = (ToolHolderArmature)armature;
            OpenMatrix4f modelMatrix = new OpenMatrix4f((OpenMatrix4f)this.mainhandCorrectionTransforms.get("Tool_R"));
            boolean isInMainhand = hand == InteractionHand.MAIN_HAND;
            Joint holdingHand = isInMainhand ? armature2.rightToolJoint() : armature2.leftToolJoint();
            OpenMatrix4f jointTransform = poses[holdingHand.getId()];
            modelMatrix.mulFront(jointTransform);
            if (!isInMainhand) {
                modelMatrix.translate(1.0f, 0.0f, 0.0f);
            }
            poseStack.m_85836_();
            MathUtils.mulStack((PoseStack)poseStack, (OpenMatrix4f)modelMatrix);
            ItemDisplayContext transformType = isInMainhand ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            Minecraft.m_91087_().m_91291_().m_269128_(stack, transformType, packedLight, OverlayTexture.f_118083_, poseStack, buffer, null, 0);
            if (entitypatch instanceof PlayerPatch && (player = (PlayerPatch)entitypatch).getSkill(WOMSkills.REGIERUNG) != null && player.getSkill(WOMSkills.REGIERUNG).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) != null && (Integer)player.getSkill(WOMSkills.REGIERUNG).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) > 0) {
                int charging_time = (Integer)player.getSkill(WOMSkills.REGIERUNG).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get());
                poseStack.m_85841_((float)((double)1.1f + Math.sin(Math.PI * (double)((LivingEntity)entitypatch.getOriginal()).f_19797_ / 20.0) * (double)0.1f), 1.0f + (float)Math.min(500, charging_time) / 50.0f * 0.05f, (float)((double)1.2f + Math.sin(Math.PI * (double)((LivingEntity)entitypatch.getOriginal()).f_19797_ / 20.0) * (double)0.2f));
                poseStack.m_85837_(0.0, 0.0, (double)-0.025f - Math.sin(Math.PI * (double)((LivingEntity)entitypatch.getOriginal()).f_19797_ / 20.0) * (double)0.025f);
                Minecraft.m_91087_().m_91291_().m_269128_(this.Aura, transformType, (int)(Math.sin(Math.PI * (double)((LivingEntity)entitypatch.getOriginal()).f_19797_ / 20.0) * 55.0 + 200.0), OverlayTexture.f_118083_, poseStack, buffer, null, 0);
            }
            poseStack.m_85849_();
        }
    }
}

