/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DodgeMasterSkill
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("691d9d1e-05ce-11ed-b939-0242ac120002");

    public DodgeMasterSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 4 && this.isdodgeableSource(event.getDamageSource())) {
                if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)true);
                }
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false);
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    public boolean isdodgeableSource(DamageSource damagesource) {
        return !damagesource.m_269533_(DamageTypeTags.f_268415_) && !damagesource.m_276093_(DamageTypes.f_268515_) && !damagesource.m_269533_(DamageTypeTags.f_268490_) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && (damagesource.m_269533_(EpicFightDamageTypeTags.BYPASS_DODGE) || !damagesource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer container, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)container.getExecutor().getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)container.getExecutor().getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        Minecraft instance = Minecraft.m_91087_();
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = instance.f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPSkillRequest packet = new CPSkillRequest(container.getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        int i = args.readInt();
        float yaw = args.readFloat();
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 && !((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], 0.0f);
            container.getExecutor().setModelYRot(yaw, true);
            container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.getConsumption(), true, args);
        }
        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)10);
        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.STEP;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        if (!executer.isInAir() && playerState.canUseSkill() && !((Player)executer.getOriginal()).m_6147_() && !(executer.getStamina() < (float)((Integer)((SkillContainer)executer.getSkillContainerFor((Skill)this).get()).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 ? 8 : 4))) {
            ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_11705_, 0.3f, 2.0f);
            return true;
        }
        ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_12031_, 1.0f, 2.0f);
        return false;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 && !container.getExecutor().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
            if (((ServerPlayerPatch)container.getExecutor()).getStamina() > 0.0f) {
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, 1.0f, true, null);
                    container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[Math.abs(new Random().nextInt()) % 2 + 2], 0.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)14);
                }
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false);
                }
            }
        }
    }
}

