/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.animations.weapons.AnimsAgony;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.gameasset.animations.weapons.AnimsMoonless;
import reascer.wom.gameasset.animations.weapons.AnimsRuine;
import reascer.wom.gameasset.animations.weapons.AnimsSatsujin;
import reascer.wom.gameasset.animations.weapons.AnimsSolar;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.particle.WOMParticles;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.damagesources.WOMDamageType;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class BusterParadeSkill
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("2ae39a02-d74f-42e7-ad4f-7b95c97c1a13");

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder();
    }

    public BusterParadeSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, GuardSkill.EVENT_UUID, 1);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class);
            if (targetPatch != null && event.getDamageSource().m_269533_(WOMDamageType.BLACKOUT) && (event.getTarget().m_21254_() || targetPatch.getCurrentLivingMotion().isSame((LivingMotion)LivingMotions.BLOCK) || targetPatch.getCurrentLivingMotion().isSame((LivingMotion)LivingMotions.BLOCK_SHIELD) || !targetPatch.isStunned() && !targetPatch.getEntityState().attacking() && !targetPatch.getEntityState().canBasicAttack())) {
                Boolean no_blackout_tag = true;
                for (String tag : event.getTarget().m_19880_()) {
                    if (!tag.contains("WoM_blackout")) continue;
                    no_blackout_tag = false;
                    event.getTarget().m_19880_().remove(tag);
                    break;
                }
                if (no_blackout_tag.booleanValue()) {
                    event.getTarget().m_20049_("WoM_blackout");
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.BLUNT_HIT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.8f, 0.5f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.4f, 0.5f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11934_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.8f, 0.8f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_(), HitParticleType.MIDDLE_OF_ENTITIES, HitParticleType.CENTER_OF_TARGET, ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), (Entity)event.getTarget());
                Vec2f facing = ReuseableEvents.getYawPitchF(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_146892_(), event.getTarget().m_146892_());
                Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20206_() / 2.0f), 0.0));
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 1.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 50, 1.6f, 0.01f, 0.5f, offset, null, facing, false, false);
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 1.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 30, 0.8f, 0.01f, 0.5f, offset, null, facing, false, false);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 1, 0.0, 0.0, 0.0, 0.5);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175830_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 30, 1.0, 1.0, 1.0, 0.2);
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 4, true, false, false));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem capabilityItem = container.getServerExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack() && capabilityItem != null && ((ServerPlayer)container.getServerExecutor().getOriginal()).m_21205_().m_41720_() instanceof SwordItem) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)true);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)40);
                if (this.getWindupAnimation(capabilityItem, event.getPlayerPatch()) != null) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(this.getWindupAnimation(capabilityItem, event.getPlayerPatch()), 0.0f);
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                // empty if block
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            CapabilityItem capabilityItem = container.getServerExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (!event.getAnimation().equals(this.getWindupAnimation(capabilityItem, event.getPlayerPatch())) && !event.getAnimation().equals(this.getReleaseAnimataion(capabilityItem, event.getPlayerPatch()))) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Attack event, float knockback, float impact, boolean advanced) {
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getWindupAnimation(CapabilityItem capabilityItem, PlayerPatch<?> playerPatch) {
        Collider collider = capabilityItem.getWeaponCollider();
        if (collider == WOMWeaponColliders.AGONY) {
            return AnimsAgony.AGONY_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.RUINE || collider == WOMWeaponColliders.EVIL_TACHI) {
            return AnimsRuine.RUINE_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.SATSUJIN) {
            return AnimsSatsujin.SATSUJIN_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.HERSCHER) {
            return AnimsHerrscher.HERRSCHER_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.SOLAR) {
            return AnimsSolar.SOLAR_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.MOONLESS) {
            return AnimsMoonless.MOONLESS_BUSTER_WINDUP;
        }
        if (collider == WOMWeaponColliders.STAFF) {
            return WOMAnimations.STAFF_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.UCHIGATANA) {
            return WOMAnimations.UCHIGATANA_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.SWORD) {
            if (capabilityItem.getStyle(playerPatch) == CapabilityItem.Styles.TWO_HAND) {
                return WOMAnimations.DUALSWORD_BUSTER_WINDUP;
            }
            return WOMAnimations.SWORD_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.GREATSWORD) {
            return WOMAnimations.GREATSWORD_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.TACHI) {
            return WOMAnimations.TACHI_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.LONGSWORD) {
            return WOMAnimations.LONGSWORD_BUSTER_WINDUP;
        }
        if (collider == ColliderPreset.SPEAR) {
            return WOMAnimations.SPEAR_BUSTER_WINDUP;
        }
        return null;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getReleaseAnimataion(CapabilityItem capabilityItem, PlayerPatch<?> playerPatch) {
        Collider collider = capabilityItem.getWeaponCollider();
        if (collider == WOMWeaponColliders.AGONY) {
            return AnimsAgony.AGONY_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.RUINE || collider == WOMWeaponColliders.EVIL_TACHI) {
            return AnimsRuine.RUINE_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.SATSUJIN) {
            return AnimsSatsujin.SATSUJIN_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.HERSCHER) {
            return AnimsHerrscher.HERRSCHER_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.SOLAR) {
            return AnimsSolar.SOLAR_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.MOONLESS) {
            return AnimsMoonless.MOONLESS_BUSTER_RELEASE;
        }
        if (collider == WOMWeaponColliders.STAFF) {
            return WOMAnimations.STAFF_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.UCHIGATANA) {
            return WOMAnimations.UCHIGATANA_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.SWORD) {
            if (capabilityItem.getStyle(playerPatch) == CapabilityItem.Styles.TWO_HAND) {
                return WOMAnimations.DUALSWORD_BUSTER_RELEASE;
            }
            return WOMAnimations.SWORD_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.GREATSWORD) {
            return WOMAnimations.GREATSWORD_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.TACHI) {
            return WOMAnimations.TACHI_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.LONGSWORD) {
            return WOMAnimations.LONGSWORD_BUSTER_RELEASE;
        }
        if (collider == ColliderPreset.SPEAR) {
            return WOMAnimations.SPEAR_BUSTER_RELEASE;
        }
        return null;
    }

    public Skill getPriorSkill() {
        return WOMSkills.COUNTER_ATTACK;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    public void updateContainer(SkillContainer container) {
        AssetAccessor animation;
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient() && ((animation = container.getExecutor().getClientAnimator().baseLayer.animationPlayer.getRealAnimation()).equals(WOMAnimations.SHADOWSTEP_LEFT) || animation.equals(WOMAnimations.SHADOWSTEP_RIGHT) || animation.equals(WOMAnimations.SHADOWSTEP_FORWARD) || animation.equals(WOMAnimations.SHADOWSTEP_BACKWARD))) {
            Player player = (Player)container.getExecutor().getOriginal();
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                ParticlesTools.particle_circle((ParticleOptions)ParticleTypes.f_123762_, null, player.m_9236_(), null, 20, 0.7f, 0.0f, 0.1f, new Vec3f(player.m_20182_().m_82520_(0.0, (double)new Random().nextFloat(0.0f, 0.5f), 0.0)), new Vec3f(0.0, -0.05, 0.0), new Vec2f(0.0f, 90.0f), false, true);
            }
        }
        if (!container.getExecutor().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch;
            float convertion;
            ServerPlayer serverplayer = (ServerPlayer)container.getServerExecutor().getOriginal();
            CapabilityItem capabilityItem = container.getServerExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) <= 23 && !serverplayer.m_6117_() && this.getReleaseAnimataion(capabilityItem, (PlayerPatch<?>)container.getServerExecutor()) != null) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
                convertion = 0.2f - 0.3f * (1.0f - (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get())).intValue() / 23.0f);
                if (capabilityItem.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                    serverPlayerPatch = container.getServerExecutor();
                    ((ServerPlayer)serverPlayerPatch.getOriginal()).m_9236_().m_5594_(null, ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20183_(), SoundEvents.f_11852_, ((ServerPlayer)serverPlayerPatch.getOriginal()).m_5720_(), 1.0f, 2.0f);
                    ((ServerLevel)((ServerPlayer)serverPlayerPatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.BLINK.get()), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20185_(), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20186_() + (double)(((ServerPlayer)serverPlayerPatch.getOriginal()).m_20206_() / 2.0f), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (capabilityItem.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                    convertion = -0.2f - 0.2f * (1.0f - (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get())).intValue() / 23.0f);
                }
                serverplayer.m_5810_();
                container.getServerExecutor().playAnimationSynchronized(this.getReleaseAnimataion(capabilityItem, (PlayerPatch<?>)container.getServerExecutor()), convertion);
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue() && this.getReleaseAnimataion(capabilityItem, (PlayerPatch<?>)container.getServerExecutor()) != null) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
                convertion = -0.1f;
                serverplayer.m_5810_();
                if (capabilityItem.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                    serverPlayerPatch = container.getServerExecutor();
                    ((ServerPlayer)serverPlayerPatch.getOriginal()).m_9236_().m_5594_(null, ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20183_(), SoundEvents.f_11852_, ((ServerPlayer)serverPlayerPatch.getOriginal()).m_5720_(), 1.0f, 2.0f);
                    ((ServerLevel)((ServerPlayer)serverPlayerPatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.BLINK.get()), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20185_(), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20186_() + (double)(((ServerPlayer)serverPlayerPatch.getOriginal()).m_20206_() / 2.0f), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (capabilityItem.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                    convertion = -0.4f;
                }
                container.getServerExecutor().playAnimationSynchronized(this.getReleaseAnimataion(capabilityItem, (PlayerPatch<?>)container.getServerExecutor()), convertion);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.GREATSWORD, CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }
}

