/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.animations.weapons.AnimsAgony;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.gameasset.animations.weapons.AnimsMoonless;
import reascer.wom.gameasset.animations.weapons.AnimsRuine;
import reascer.wom.gameasset.animations.weapons.AnimsSatsujin;
import reascer.wom.gameasset.animations.weapons.AnimsSolar;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.GuardAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class VengefulParry
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("802e2116-02fa-4746-937d-a89429a84113");

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder();
    }

    public VengefulParry(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            boolean flag1;
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            boolean bl = flag1 = !((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21255_() && ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion != LivingMotions.FALL && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canUseSkill() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack();
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && flag1 && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                AnimationManager.AnimationAccessor<GuardAnimation> animation = switch (new Random().nextInt() % 3) {
                    case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                    case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                    default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                };
                if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                    AnimationManager.AnimationAccessor<GuardAnimation> animationAccessor = animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                }
                if (itemCapability.getWeaponCollider() == ColliderPreset.SPEAR) {
                    animation = Animations.SPEAR_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                    animation = Animations.UCHIGATANA_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.STAFF) {
                    animation = Animations.SPEAR_GUARD_HIT;
                }
                float convert = -0.05f;
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY) {
                    animation = AnimsAgony.AGONY_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.RUINE) {
                    animation = AnimsRuine.RUINE_BLOCK_1;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SATSUJIN) {
                    animation = AnimsSatsujin.SATSUJIN_GUARD_HIT;
                    convert = -0.15f;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                    animation = AnimsHerrscher.HERRSCHER_GUARD_PARRY;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                    animation = AnimsMoonless.MOONLESS_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                    animation = AnimsSolar.SOLAR_GUARD_PARRY;
                }
                ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, 8.0f, true, null);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)40);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get(), (Object)true);
            } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 0) {
                event.attachValueModifier(ValueModifier.multiplier((float)(1.0f + (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get())).intValue() / 100.0f)));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().get() instanceof AttackAnimation && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 0) {
                AnimationPlayer player;
                float elapsedTime;
                ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
                AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation().get();
                AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime = (player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)event.getDamageSource().getAnimation())).getElapsedTime());
                if (phase == anim.phases[0]) {
                    ((ServerLevel)((Player)container.getExecutor().getOriginal()).m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_(), SoundEvents.f_11835_, event.getTarget().m_5720_(), 2.0f, 0.5f);
                    ((ServerLevel)((Player)container.getExecutor().getOriginal()).m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_(), SoundEvents.f_11865_, event.getTarget().m_5720_(), 1.0f, 2.0f);
                    for (int i = 0; i < (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) + 1; ++i) {
                        ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), event.getTarget().m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 3.0f), event.getTarget().m_20186_() + (double)(event.getTarget().m_20206_() / 2.0f), event.getTarget().m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 3.0f), 2, 0.0, 0.0, 0.0, 0.0);
                    }
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.VENGENCE_DURATION.get(), (Object)12);
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (super.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                float impact = 0.5f;
                float knockback = 0.25f;
                this.guard(container, itemCapability, (TakeDamageEvent.Hurt)event, knockback, impact, false);
            }
        }, 0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get(), (Object)false);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, 0);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInitiateClient(SkillContainer container) {
        super.onInitiateClient(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.UPDATE_COMPOSITE_LIVING_MOTION_EVENT, EVENT_UUID, event -> {
            if (WOMSkillDataKeys.HOLDING_STANCE.get() != null && container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get()) != null && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
                event.setMotion((LivingMotion)LivingMotions.BLOCK);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRemoveClient(SkillContainer container) {
        super.onRemoveClient(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.UPDATE_COMPOSITE_LIVING_MOTION_EVENT, EVENT_UUID);
    }

    public boolean canExecute(SkillContainer container) {
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
            return super.canExecute(container);
        }
        return false;
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Hurt event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && this.isBlockableSource(damageSource = event.getDamageSource(), true)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)serverPlayer.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverPlayer, damageSource.m_7640_());
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) + (int)event.getDamage() * 5));
            ((ServerPlayerPatch)event.getPlayerPatch()).countHurtTime(event.getDamage());
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getDamageSource().m_7639_(), LivingEntityPatch.class).ifPresent(attackerpatch -> attackerpatch.setLastAttackEntity((Entity)serverPlayer));
            EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getDamageSource().m_7640_(), LivingEntity.class, LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onAttackBlocked(event.getDamageSource(), (LivingEntityPatch)event.getPlayerPatch()));
            event.attachValueModifier(ValueModifier.setter((float)1.0E-5f));
            DamageSource damageSource2 = event.getDamageSource();
            if (damageSource2 instanceof EpicFightDamageSource) {
                EpicFightDamageSource efds = (EpicFightDamageSource)damageSource2;
                efds.setStunType(StunType.NONE);
                efds.setBaseImpact(0.0f);
                efds.attachImpactModifier(ValueModifier.multiplier((float)0.0f));
            }
            return;
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return (damageSource.m_276093_(DamageTypes.f_268482_) && advanced || damageSource.m_276093_(DamageTypes.f_268684_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268415_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || damageSource.m_276093_(DamageTypes.f_268428_) && advanced || damageSource.m_276093_(DamageTypes.f_268448_) && advanced || damageSource.m_276093_(DamageTypes.f_268679_) && advanced || damageSource.m_276093_(DamageTypes.f_268656_) && advanced || damageSource.m_276093_(DamageTypes.f_268714_) && advanced || damageSource.m_276093_(DamageTypes.f_268641_) && advanced || damageSource.m_276093_(DamageTypes.f_268556_) && advanced || super.isBlockableSource(damageSource, false)) && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE);
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY) {
                return new Random().nextBoolean() ? AnimsAgony.AGONY_GUARD_HIT_1 : AnimsAgony.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SATSUJIN) {
                return AnimsSatsujin.SATSUJIN_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                if (itemCapability.getStyle(playerpatch) == CapabilityItem.Styles.COMMON) {
                    return AnimsHerrscher.HERRSCHER_MAHER_HOLD_HIT;
                }
                return AnimsHerrscher.HERRSCHER_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                return AnimsSolar.SOLAR_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return AnimsMoonless.MOONLESS_GUARD_HIT_3;
                    }
                }
                return AnimsMoonless.MOONLESS_GUARD_HIT_1;
            }
        }
        return super.getGuardMotion(container, playerpatch, itemCapability, blockType);
    }

    public Skill getPriorSkill() {
        return WOMSkills.PERFECT_BULWARK;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 0 || (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        Object string = String.valueOf(container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get())) + "%";
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) == 0) {
            string = "";
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            string = String.valueOf(((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1) / 20 + 1);
        }
        guiGraphics.drawString(gui.getFont(), (String)string, x + 12.0f - (float)(gui.getFont().m_92895_((String)string) / 2), y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 5) {
                    ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 10, true, false, false));
                    ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 10, true, false, false));
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get(), (Object)false);
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            container.getDataManager().setData((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VENGENCE_DURATION.get()) > 0) {
            container.getDataManager().setData((SkillDataKey)WOMSkillDataKeys.VENGENCE_DURATION.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VENGENCE_DURATION.get()) - 1));
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VENGENCE_DURATION.get()) == 0 && !container.getExecutor().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0);
            }
        }
    }
}

