/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.identity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BackAndForthSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("05e61b67-4531-4127-b973-9f572acede5c");

    public BackAndForthSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)event.getTarget().m_19879_());
            if (event.getDamageSource().getAnimation().equals(WOMAnimations.STRONG_PUNCH)) {
                Boolean no_blackout_tag = true;
                for (String tag : event.getTarget().m_19880_()) {
                    if (!tag.contains("WoM_blackout")) continue;
                    no_blackout_tag = false;
                    break;
                }
                if (no_blackout_tag.booleanValue()) {
                    event.getTarget().m_20049_("WoM_blackout");
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.BLUNT_HIT.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.8f, 0.5f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), ((Player)container.getExecutor().getOriginal()).m_5720_(), 0.6f, 2.5f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_(), HitParticleType.MIDDLE_OF_ENTITIES, HitParticleType.CENTER_OF_TARGET, ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), (Entity)event.getTarget());
                Vec2f facing = ReuseableEvents.getYawPitchF(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_146892_(), event.getTarget().m_146892_());
                Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20206_() / 2.0f), 0.0));
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 50, 1.6f, 0.01f, 0.5f, offset, null, facing, false, false);
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), event.getPlayerPatch(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_284548_(), null, 30, 0.8f, 0.01f, 0.5f, offset, null, facing, false, false);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((Player)container.getExecutor().getOriginal()).m_20185_() + (double)offset.x, ((Player)container.getExecutor().getOriginal()).m_20186_() + (double)offset.y, ((Player)container.getExecutor().getOriginal()).m_20189_() + (double)offset.z, 1, 0.0, 0.0, 0.0, 0.5);
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 2, true, false, false));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() >= 20.0f && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20142_()) {
                ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                executer.playAnimationSynchronized(WOMAnimations.STRONG_PUNCH, 0.0f);
                event.setCanceled(true);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(0.0f));
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)0);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get()) != 0 || ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() >= 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() < 20.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.2f, (float)0.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = "";
        if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() < 20.0f) {
            string = String.format("%.1f", container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get()));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 10.0f - (float)(string.length() * 2), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get()) != 0) {
            Entity targetEntity = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get())).intValue());
            if (targetEntity != null) {
                if (((Player)container.getExecutor().getOriginal()).m_20270_(targetEntity) > ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(((Player)container.getExecutor().getOriginal()).m_20270_(targetEntity)));
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)0);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(0.0f));
            }
        }
    }
}

